% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ports.R
\name{freePort}
\alias{freePort}
\title{Find a TCP port that can be opened}
\usage{
freePort(ports = 1024:65535, default = "random", randomize = TRUE)
}
\arguments{
\item{ports}{(integer vector, or character string)
Zero or more TCP ports in [0, 65535] to scan.
If \code{"random"}, then a random set of ports is considered.
If \code{"auto"}, then the port given by environment variable
\env{R_PARALLEL_PORT} is used, which may also specify \code{random}.}

\item{default}{(integer) \code{NA_integer_} or a port to returned if
an available port could not be found.
If \code{"first"}, then \code{ports[1]}.  If \code{"random"}, then a random port
among \code{ports} is used. If \code{length(ports) == 0}, then \code{NA_integer_}.}

\item{randomize}{(logical) If TRUE, \code{ports} is randomly shuffled
before searched.  This shuffle does \emph{not} forward the RNG seed.}
}
\value{
Returns an integer representing the first port among \code{ports} that
can be opened.  If none can be opened, then \code{default} is returned.
If port querying is not supported, as in R (< 4.0.0), then \code{default}
is returned.
}
\description{
Find a TCP port that can be opened
}
