% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneNode.R
\name{cloneNode}
\alias{cloneNode}
\title{Clone one or more nodes}
\usage{
cloneNode(x, ...)
}
\arguments{
\item{x}{A cluster node or a cluster.}

\item{...}{Optional arguments overriding the recorded ones.}
}
\value{
An object of class \code{class(x)}.
}
\description{
Clone one or more nodes
}
\examples{
\donttest{
cl <- makeClusterPSOCK(2)
print(cl)

## Terminate the second cluster node
parallel::stopCluster(cl[2])

## Show that cluster node #2 is no longer alive (wait a bit first)
Sys.sleep(1.0)
print(isNodeAlive(cl))
print(cl)

## "Restart" it
cl[2] <- cloneNode(cl[2])
print(cl)

## Check all nodes
print(isNodeAlive(cl))
}

}
