% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment_sn.R
\name{moment_sn}
\alias{moment_sn}
\title{Moments of Skew-Normal Distribution}
\usage{
moment_sn(xi = 0, omega = 1, alpha = 0)
}
\arguments{
\item{xi, omega, alpha}{\link[base]{numeric} scalars or \link[base]{vector}s,
location, scale and slant parameters of skew-normal distribution}
}
\value{
Function \link{moment_sn} returns a \linkS4class{moment} object.
}
\description{
Moments of \href{https://en.wikipedia.org/wiki/Skew_normal_distribution}{skew-normal distribution}, parameter nomenclature follows
\link[sn]{dsn} function.
}
\examples{
xi = 2; omega = 1.3; alpha = 3
moment_sn(xi, omega, alpha)
curve(sn::dsn(x, xi = 2, omega = 1.3, alpha = 3), from = 0, to = 6)

}
