% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st.R
\name{moment2st}
\alias{moment2st}
\alias{moment2t_demo}
\title{Solve Skew-\eqn{t} Parameters from Moments}
\usage{
moment2st(mean = 0, sd = 1, skewness, kurtosis)

moment2t_demo(sd = 1, kurtosis)
}
\arguments{
\item{mean}{\link[base]{numeric} scalar, mean \eqn{\mu}, default value 0}

\item{sd}{\link[base]{numeric} scalar, standard deviation \eqn{\sigma}, default value 1}

\item{skewness}{\link[base]{numeric} scalar}

\item{kurtosis}{\link[base]{numeric} scalar}
}
\value{
Function \link{moment2st} returns a \link[base]{length}-4 \link[base]{numeric} \link[base]{vector}
\eqn{(\xi, \omega, \alpha, \nu)}.

Function \link{moment2t_demo} returns a \link[base]{length}-2
\link[base]{numeric} \link[base]{vector} \eqn{(\omega, \nu)}.
}
\description{
Solve skew-\eqn{t} parameters from mean, standard deviation, skewness and kurtosis.
}
\details{
Function \link{moment2st} solves the
location \eqn{\xi}, scale \eqn{\omega}, slant \eqn{\alpha}
and degree of freedom \eqn{\nu} parameters of skew-\eqn{t} distribution,
from user-specified mean \eqn{\mu} (default 0), standard deviation \eqn{\sigma} (default 1),
skewness and kurtosis.

An educational and demonstration function \link{moment2t_demo} solves
\eqn{(\omega, \nu)} parameters of \eqn{t}-distribution,
from user-specified \eqn{\sigma} and kurtosis.
This is a non-skewed distribution, thus
the location parameter \eqn{\xi=\mu=0}, and the slant parameter \eqn{\alpha=0}.
}
\examples{
moment2st(skewness = .2, kurtosis = .3)

moment2t_demo(kurtosis = .3)

}
