% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_aov.R
\name{model_parameters.aov}
\alias{model_parameters.aov}
\alias{model_parameters.anova}
\alias{model_parameters.aovlist}
\alias{model_parameters.afex_aov}
\alias{model_parameters.anova.rms}
\alias{model_parameters.Anova.mlm}
\alias{model_parameters.maov}
\title{Parameters from ANOVAs}
\usage{
\method{model_parameters}{aov}(
  model,
  type = NULL,
  df_error = NULL,
  ci = NULL,
  alternative = NULL,
  test = NULL,
  power = FALSE,
  effectsize_type = NULL,
  keep = NULL,
  drop = NULL,
  table_wide = FALSE,
  verbose = TRUE,
  omega_squared = NULL,
  eta_squared = NULL,
  epsilon_squared = NULL,
  ...
)

\method{model_parameters}{anova}(
  model,
  type = NULL,
  df_error = NULL,
  ci = NULL,
  alternative = NULL,
  test = NULL,
  power = FALSE,
  effectsize_type = NULL,
  keep = NULL,
  drop = NULL,
  table_wide = FALSE,
  verbose = TRUE,
  omega_squared = NULL,
  eta_squared = NULL,
  epsilon_squared = NULL,
  ...
)

\method{model_parameters}{aovlist}(
  model,
  type = NULL,
  df_error = NULL,
  ci = NULL,
  alternative = NULL,
  test = NULL,
  power = FALSE,
  effectsize_type = NULL,
  keep = NULL,
  drop = NULL,
  table_wide = FALSE,
  verbose = TRUE,
  omega_squared = NULL,
  eta_squared = NULL,
  epsilon_squared = NULL,
  ...
)

\method{model_parameters}{afex_aov}(
  model,
  effectsize_type = NULL,
  df_error = NULL,
  type = NULL,
  keep = NULL,
  drop = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{anova.rms}(
  model,
  type = NULL,
  df_error = NULL,
  ci = NULL,
  alternative = NULL,
  test = NULL,
  power = FALSE,
  effectsize_type = NULL,
  keep = NULL,
  drop = NULL,
  table_wide = FALSE,
  verbose = TRUE,
  omega_squared = NULL,
  eta_squared = NULL,
  epsilon_squared = NULL,
  ...
)

\method{model_parameters}{Anova.mlm}(
  model,
  type = NULL,
  df_error = NULL,
  ci = NULL,
  alternative = NULL,
  test = NULL,
  power = FALSE,
  effectsize_type = NULL,
  keep = NULL,
  drop = NULL,
  table_wide = FALSE,
  verbose = TRUE,
  omega_squared = NULL,
  eta_squared = NULL,
  epsilon_squared = NULL,
  ...
)

\method{model_parameters}{maov}(
  model,
  type = NULL,
  df_error = NULL,
  ci = NULL,
  alternative = NULL,
  test = NULL,
  power = FALSE,
  effectsize_type = NULL,
  keep = NULL,
  drop = NULL,
  table_wide = FALSE,
  verbose = TRUE,
  omega_squared = NULL,
  eta_squared = NULL,
  epsilon_squared = NULL,
  ...
)
}
\arguments{
\item{model}{Object of class \code{\link[=aov]{aov()}}, \code{\link[=anova]{anova()}},
\code{aovlist}, \code{Gam}, \code{\link[=manova]{manova()}}, \code{Anova.mlm},
\code{afex_aov} or \code{maov}.}

\item{type}{Numeric, type of sums of squares. May be 1, 2 or 3. If 2 or 3,
ANOVA-tables using \code{car::Anova()} will be returned. (Ignored for
\code{afex_aov}.)}

\item{df_error}{Denominator degrees of freedom (or degrees of freedom of the
error estimate, i.e., the residuals). This is used to compute effect sizes
for ANOVA-tables from mixed models. See 'Examples'. (Ignored for
\code{afex_aov}.)}

\item{ci}{Confidence Interval (CI) level for effect sizes
\code{omega_squared}, \code{eta_squared} etc. The default, \code{NULL},
will compute no confidence intervals. \code{ci} should be a scalar between
0 and 1.}

\item{alternative}{A character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed
(e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See section \emph{One-Sided CIs} in
the \href{https://easystats.github.io/effectsize/}{effectsize_CIs vignette}.}

\item{test}{String, indicating the type of test for \code{Anova.mlm} to be
returned. If \code{"multivariate"} (or \code{NULL}), returns the summary of
the multivariate test (that is also given by the \code{print}-method). If
\code{test = "univariate"}, returns the summary of the univariate test.}

\item{power}{Logical, if \code{TRUE}, adds a column with power for each
parameter.}

\item{effectsize_type}{The effect size of interest. Not that possibly not all
effect sizes are applicable to the model object. See 'Details'. For Anova
models, can also be a character vector with multiple effect size names.}

\item{keep}{Character containing a regular expression pattern that
describes the parameters that should be included (for \code{keep}) or excluded
(for \code{drop}) in the returned data frame. \code{keep} may also be a
named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{keep} is a character vector, every parameter
name in the \emph{"Parameter"} column that matches the regular expression in
\code{keep} will be selected from the returned data frame (and vice versa,
all parameter names matching \code{drop} will be excluded). Furthermore, if
\code{keep} has more than one element, these will be merged with an \code{OR}
operator into a regular expression pattern like this: \code{"(one|two|three)"}.
If \code{keep} is a named list of regular expression patterns, the names of the
list-element should equal the column name where selection should be
applied. This is useful for model objects where \code{model_parameters()}
returns multiple columns with parameter components, like in
\code{\link[=model_parameters.lavaan]{model_parameters.lavaan()}}. Note that the regular expression pattern
should match the parameter names as they are stored in the returned data
frame, which can be different from how they are printed. Inspect the
\verb{$Parameter} column of the parameters table to get the exact parameter
names.}

\item{drop}{See \code{keep}.}

\item{table_wide}{Logical that decides whether the ANOVA table should be in
wide format, i.e. should the numerator and denominator degrees of freedom
be in the same row. Default: \code{FALSE}.}

\item{verbose}{Toggle warnings and messages.}

\item{omega_squared, eta_squared, epsilon_squared}{Deprecated. Please use \code{effectsize_type}.}

\item{...}{Arguments passed to \code{\link[effectsize:effectsize]{effectsize::effectsize()}}. For example,
to calculate \emph{partial} effect sizes types, use \code{partial = TRUE}. For objects
of class \code{htest} or \code{BFBayesFactor}, \code{adjust = TRUE} can be used to return
bias-corrected effect sizes, which is advisable for small samples and large
tables. See also
\href{https://easystats.github.io/effectsize/reference/eta_squared.html}{\code{?effectsize::eta_squared}}
for arguments \code{partial} and \code{generalized};
\href{https://easystats.github.io/effectsize/reference/phi.html}{\code{?effectsize::phi}}
for \code{adjust}; and
\href{https://easystats.github.io/effectsize/reference/oddsratio.html}{\code{?effectsize::oddratio}}
for \code{log}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters from ANOVAs
}
\details{
\itemize{
\item For an object of class \code{htest}, data is extracted via \code{\link[insight:get_data]{insight::get_data()}}, and passed to the relevant function according to:
\itemize{
\item A \strong{t-test} depending on \code{type}: \code{"cohens_d"} (default), \code{"hedges_g"}, or one of \code{"p_superiority"}, \code{"u1"}, \code{"u2"}, \code{"u3"}, \code{"overlap"}.
\item A \strong{Chi-squared tests of independence} or \strong{Fisher's Exact Test}, depending on \code{type}: \code{"cramers_v"} (default), \code{"tschuprows_t"}, \code{"phi"}, \code{"cohens_w"}, \code{"pearsons_c"}, \code{"cohens_h"}, \code{"oddsratio"}, or \code{"riskratio"}.
\item A \strong{Chi-squared tests of goodness-of-fit}, depending on \code{type}: \code{"fei"} (default) \code{"cohens_w"}, \code{"pearsons_c"}
\item A \strong{One-way ANOVA test}, depending on \code{type}: \code{"eta"} (default), \code{"omega"} or \code{"epsilon"} -squared, \code{"f"}, or \code{"f2"}.
\item A \strong{McNemar test} returns \emph{Cohen's g}.
\item A \strong{Wilcoxon test} depending on \code{type}: returns "\code{rank_biserial}" correlation (default) or one of \code{"p_superiority"}, \code{"vda"}, \code{"u2"}, \code{"u3"}, \code{"overlap"}.
\item A \strong{Kruskal-Wallis test} depending on \code{type}: \code{"epsilon"} (default) or \code{"eta"}.
\item A \strong{Friedman test} returns \emph{Kendall's W}.
(Where applicable, \code{ci} and \code{alternative} are taken from the \code{htest} if not otherwise provided.)
}
\item For an object of class \code{BFBayesFactor}, using \code{\link[bayestestR:describe_posterior]{bayestestR::describe_posterior()}},
\itemize{
\item A \strong{t-test} depending on \code{type}: \code{"cohens_d"} (default) or one of \code{"p_superiority"}, \code{"u1"}, \code{"u2"}, \code{"u3"}, \code{"overlap"}.
\item A \strong{correlation test} returns \emph{r}.
\item A \strong{contingency table test}, depending on \code{type}: \code{"cramers_v"} (default), \code{"phi"}, \code{"tschuprows_t"}, \code{"cohens_w"}, \code{"pearsons_c"}, \code{"cohens_h"}, \code{"oddsratio"}, or \code{"riskratio"}.
\item A \strong{proportion test} returns \emph{p}.
}
\item Objects of class \code{anova}, \code{aov}, \code{aovlist} or \code{afex_aov}, depending on \code{type}: \code{"eta"} (default), \code{"omega"} or \code{"epsilon"} -squared, \code{"f"}, or \code{"f2"}.
\item Other objects are passed to \code{\link[parameters:standardize_parameters]{parameters::standardize_parameters()}}.
}

\strong{For statistical models it is recommended to directly use the listed
functions, for the full range of options they provide.}
}
\note{
For ANOVA-tables from mixed models (i.e. \code{anova(lmer())}), only
partial or adjusted effect sizes can be computed. Note that type 3 ANOVAs
with interactions involved only give sensible and informative results when
covariates are mean-centred and factors are coded with orthogonal contrasts
(such as those produced by \code{contr.sum}, \code{contr.poly}, or
\code{contr.helmert}, but \emph{not} by the default \code{contr.treatment}).
}
\examples{
\dontshow{if (requireNamespace("effectsize", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
df <- iris
df$Sepal.Big <- ifelse(df$Sepal.Width >= 3, "Yes", "No")

model <- aov(Sepal.Length ~ Sepal.Big, data = df)
model_parameters(
  model,
  omega_squared = "partial",
  eta_squared = "partial",
  epsilon_squared = "partial"
)

model_parameters(
  model,
  effectsize_type = c("omega", "eta"),
  ci = .9
)

model <- anova(lm(Sepal.Length ~ Sepal.Big, data = df))
model_parameters(model)
model_parameters(
  model,
  effectsize_type = c("omega", "eta", "epsilon")
)

model <- aov(Sepal.Length ~ Sepal.Big + Error(Species), data = df)
model_parameters(model)
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("lme4", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
mm <- lmer(Sepal.Length ~ Sepal.Big + Petal.Width + (1 | Species), data = df)
model <- anova(mm)

# simple parameters table
model_parameters(model)

# parameters table including effect sizes
model_parameters(
  model,
  effectsize_type = "eta",
  ci = .9,
  df_error = dof_satterthwaite(mm)[2:3]
)
}
\dontshow{\}) # examplesIf}
}
