% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.BayesFM.R
\name{model_parameters.befa}
\alias{model_parameters.befa}
\title{Parameters from PCA/FA}
\usage{
\method{model_parameters}{befa}(
  model,
  sort = FALSE,
  centrality = "median",
  dispersion = FALSE,
  ci = 0.89,
  ci_method = "hdi",
  test = NULL,
  ...
)
}
\arguments{
\item{model}{Bayesian EFA created by the \code{BayesFM::befa}.}

\item{sort}{Sort the loadings.}

\item{centrality}{The point-estimates (centrality indices) to compute.  Character (vector) or list with one or more of these options: \code{"median"}, \code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{dispersion}{Logical, if \code{TRUE}, computes indices of dispersion related to the estimate(s) (\code{SD} and \code{MAD} for \code{mean} and \code{median}, respectively).}

\item{ci}{Value or vector of probability of the CI (between 0 and 1)
to be estimated. Default to \code{.89} (89\%) for Bayesian models and \code{.95} (95\%) for frequentist models.}

\item{ci_method}{The type of index used for Credible Interval. Can be
\code{"HDI"} (default, see \code{\link[bayestestR:hdi]{hdi}}), \code{"ETI"}
(see \code{\link[bayestestR:eti]{eti}}) or \code{"SI"}
(see \code{\link[bayestestR:si]{si}}).}

\item{test}{The indices of effect existence to compute. Character (vector) or
list with one or more of these options: \code{"p_direction"} (or \code{"pd"}),
\code{"rope"}, \code{"p_map"}, \code{"equivalence_test"} (or \code{"equitest"}),
\code{"bayesfactor"} (or \code{"bf"}) or \code{"all"} to compute all tests.
For each "test", the corresponding \pkg{bayestestR} function is called
(e.g. \code{\link[bayestestR:rope]{rope}} or \code{\link[bayestestR:p_direction]{p_direction}}) and its results
included in the summary output.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame of loadings.
}
\description{
Format PCA/FA objects from the psych package (Revelle, 2016).
}
\examples{
library(parameters)
\donttest{
if (require("BayesFM")) {
  efa <- BayesFM::befa(mtcars, iter = 1000)
  results <- model_parameters(efa, sort = TRUE)
  results
  efa_to_cfa(results)
}
}
}
