% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transferMarkerdata.R
\name{transferMarkerdata}
\alias{transferMarkerdata}
\title{Transfer marker data}
\usage{
transferMarkerdata(from, to)
}
\arguments{
\item{from}{a \code{\link{linkdat}} or \code{\link{singleton}} object, or a list of such objects.}

\item{to}{a \code{\link{linkdat}} or \code{\link{singleton}} object, or a list of such objects.}
}
\value{
A \code{linkdat} object (or a list of such)
similar to \code{to}, but where all individuals also present in \code{from}
have marker genotypes copied over.  Any previous marker data is erased.
}
\description{
Transfer marker data between pedigrees (in the form of \code{\link{linkdat}} objects).
Both the source and target can be lists of linkdat and/or singleton objects (these 
must have disjoint ID sets). Any previous marker data of the target is overwritten.
}
\examples{

x = list(singleton(id=5), nuclearPed(noffs=2))
x = markerSim(x, N=5, alleles=1:5, verbose=FALSE, available=4:5)
y = nuclearPed(noffs=3)
y = transferMarkerdata(x, y)
stopifnot(all.equal(x[[1]], branch(y,5)))
stopifnot(all.equal(x[[2]], subset(y,1:4)))

}
\seealso{
\code{\link{linkdat}}
}
\author{
Magnus Dehli Vigeland
}
