% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_to_parquet.R
\name{json_to_parquet}
\alias{json_to_parquet}
\title{Convert a json file to parquet format}
\usage{
json_to_parquet(
  path_to_file,
  path_to_parquet,
  format = "json",
  partition = "no",
  compression = "snappy",
  compression_level = NULL,
  ...
)
}
\arguments{
\item{path_to_file}{String that indicates the path to the input file (don't forget the extension).}

\item{path_to_parquet}{String that indicates the path to the directory where the parquet files will be stored.}

\item{format}{string that indicates if the format is "json" (by default) or "ndjson"}

\item{partition}{String ("yes" or "no" - by default) that indicates whether you want to create a partitioned parquet file.
If "yes", `"partitioning"` argument must be filled in. In this case, a folder will be created for each modality of the variable filled in `"partitioning"`.
Be careful, this argument can not be "yes" if `max_memory` or `max_rows` argument are not NULL.}

\item{compression}{compression algorithm. Default "snappy".}

\item{compression_level}{compression level. Meaning depends on compression algorithm.}

\item{...}{additional format-specific arguments, see \href{https://arrow.apache.org/docs/r/reference/write_parquet.html}{arrow::write_parquet()}
and \href{https://arrow.apache.org/docs/r/reference/write_dataset.html}{arrow::write_dataset()} for more informations.}
}
\value{
A parquet file, invisibly
}
\description{
This function allows to convert a \href{https://www.json.org/json-en.html}{json}
or \href{https://docs.mulesoft.com/dataweave/latest/dataweave-formats-ndjson}{ndjson} file to parquet format. \cr

Two conversions possibilities are offered :

\itemize{

\item{Convert to a single parquet file. Argument `path_to_parquet` must then be used;}
\item{Convert to a partitioned parquet file. Additionnal arguments `partition` and `partitioning` must then be used;}

}
}
\examples{

# Conversion from a local json file to a single parquet file ::

json_to_parquet(
  path_to_file = system.file("extdata","iris.json",package = "parquetize"),
  path_to_parquet = tempfile(fileext = ".parquet")
)

# Conversion from a local ndjson file to a partitioned parquet file  ::

json_to_parquet(
  path_to_file = system.file("extdata","iris.ndjson",package = "parquetize"),
  path_to_parquet = tempfile(fileext = ".parquet"),
  format = "ndjson"
)
}
