% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantitate.R
\name{merge_top_peptides}
\alias{merge_top_peptides}
\title{Average areas of top three peptides from multiple technical replicates}
\usage{
merge_top_peptides(df, num_reps, match_peps = TRUE)
}
\arguments{
\item{df}{A data frame generated from \code{\link{make_area_table}} for a single protein group with the column \code{tech_rep} to indicate the technical replicate}

\item{num_reps}{numeric Number of technical replicates being combined}

\item{match_peps}{boolean Should we only quantitate based on peptides present in all replicates?}
}
\value{
A data frame that corresponds to a single protein group.

\item{area_mean}{average peptide area}
\item{area_sd}{peptide area standard deviation}
\item{peps_per_rep}{number of peptides per technical replicate used to calculate area_mean and area_sd. This is typically 3, but may be less.}
}
\description{
Takes a data frame containing peptide information for a single protein group and several technical replicates and averages the most abundant peptides (by area) across all replicates. By default, this function takes the averages across the top three peptides. This function will also optionally match peptides across replicates so only matching peptides are averaged together.
}
\examples{
\dontrun{merge_top_peptides(df, 2, match_peps = T)}
}
\keyword{internal}

