% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg_LiblineaR.R
\name{details_logistic_reg_LiblineaR}
\alias{details_logistic_reg_LiblineaR}
\title{Logistic regression via LiblineaR}
\description{
\code{\link[LiblineaR:LiblineaR]{LiblineaR::LiblineaR()}} fits a generalized linear model for binary outcomes. A
linear combination of the predictors is used to model the log odds of an
event.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: see
below)
\item \code{mixture}: Proportion of Lasso Penalty (type: double, default: 0)
}

For \code{LiblineaR} models, the value for \code{mixture} can either be 0 (for
ridge) or 1 (for lasso) but not other intermediate values. In the
\code{\link[LiblineaR:LiblineaR]{LiblineaR::LiblineaR()}} documentation, these
correspond to types 0 (L2-regularized) and 6 (L1-regularized).

Be aware that the \code{LiblineaR} engine regularizes the intercept. Other
regularized regression models do not, which will result in different
parameter estimates.
}

\subsection{Translation from parsnip to the original package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logistic_reg(penalty = double(1), mixture = double(1)) \%>\% 
  set_engine("LiblineaR") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Logistic Regression Model Specification (classification)
## 
## Main Arguments:
##   penalty = double(1)
##   mixture = double(1)
## 
## Computational engine: LiblineaR 
## 
## Model fit template:
## LiblineaR::LiblineaR(x = missing_arg(), y = missing_arg(), cost = Inf, 
##     type = double(1), verbose = FALSE)
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#logistic-reg-LiblineaR}{examples}
for \code{logistic_reg()} with the \code{"LiblineaR"} engine.
}

\subsection{References}{
\itemize{
\item Hastie, T, R Tibshirani, and M Wainwright. 2015. \emph{Statistical
Learning with Sparsity}. CRC Press.
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
