% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fit_xrf.R
\name{details_rule_fit_xrf}
\alias{details_rule_fit_xrf}
\title{RuleFit models via xrf}
\description{
\code{\link[xrf:xrf]{xrf::xrf()}} fits a model that derives simple feature rules from a tree
ensemble and uses the rules as features to a regularized model. \code{\link[rules:rules-internal]{rules::xrf_fit()}}
is a wrapper around this function.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 8 tuning parameters:
\itemize{
\item \code{mtry}: Proportion Randomly Selected Predictors (type: double,
default: see below)
\item \code{trees}: # Trees (type: integer, default: 15L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 1L)
\item \code{tree_depth}: Tree Depth (type: integer, default: 6L)
\item \code{learn_rate}: Learning Rate (type: double, default: 0.3)
\item \code{loss_reduction}: Minimum Loss Reduction (type: double, default:
0.0)
\item \code{sample_size}: Proportion Observations Sampled (type: double,
default: 1.0)
\item \code{penalty}: Amount of Regularization (type: double, default: 0.1)
}
}

\subsection{Translation from parsnip to the underlying model call (regression)}{

The \strong{rules} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(rules)

rule_fit(
  mtry = numeric(1),
  trees = integer(1),
  min_n = integer(1),
  tree_depth = integer(1),
  learn_rate = numeric(1),
  loss_reduction = numeric(1),
  sample_size = numeric(1),
  penalty = numeric(1)
) \%>\%
  set_engine("xrf") \%>\%
  set_mode("regression") \%>\%
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## RuleFit Model Specification (regression)
## 
## Main Arguments:
##   mtry = numeric(1)
##   trees = integer(1)
##   min_n = integer(1)
##   tree_depth = integer(1)
##   learn_rate = numeric(1)
##   loss_reduction = numeric(1)
##   sample_size = numeric(1)
##   penalty = numeric(1)
## 
## Computational engine: xrf 
## 
## Model fit template:
## rules::xrf_fit(formula = missing_arg(), data = missing_arg(), 
##     xgb_control = missing_arg(), colsample_bynode = numeric(1), 
##     nrounds = integer(1), min_child_weight = integer(1), max_depth = integer(1), 
##     eta = numeric(1), gamma = numeric(1), subsample = numeric(1), 
##     lambda = numeric(1))
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the underlying model call (classification)}{

The \strong{rules} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(rules)

rule_fit(
  mtry = numeric(1),
  trees = integer(1),
  min_n = integer(1),
  tree_depth = integer(1),
  learn_rate = numeric(1),
  loss_reduction = numeric(1),
  sample_size = numeric(1),
  penalty = numeric(1)
) \%>\%
  set_engine("xrf") \%>\%
  set_mode("classification") \%>\%
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## RuleFit Model Specification (classification)
## 
## Main Arguments:
##   mtry = numeric(1)
##   trees = integer(1)
##   min_n = integer(1)
##   tree_depth = integer(1)
##   learn_rate = numeric(1)
##   loss_reduction = numeric(1)
##   sample_size = numeric(1)
##   penalty = numeric(1)
## 
## Computational engine: xrf 
## 
## Model fit template:
## rules::xrf_fit(formula = missing_arg(), data = missing_arg(), 
##     xgb_control = missing_arg(), colsample_bynode = numeric(1), 
##     nrounds = integer(1), min_child_weight = integer(1), max_depth = integer(1), 
##     eta = numeric(1), gamma = numeric(1), subsample = numeric(1), 
##     lambda = numeric(1))
}\if{html}{\out{</div>}}
}

\subsection{Differences from the xrf package}{

Note that, per the documentation in \code{?xrf}, transformations of the
response variable are not supported. To use these with \code{rule_fit()}, we
recommend using a recipe instead of the formula method.

Also, there are several configuration differences in how \code{xrf()} is fit
between that package and the wrapper used in \strong{rules}. Some differences
in default values are:\tabular{lll}{
   parameter \tab \strong{xrf} \tab \strong{rules} \cr
   \code{trees} \tab 100 \tab 15 \cr
   \code{max_depth} \tab 3 \tab 6 \cr
}


These differences will create a disparity in the values of the \code{penalty}
argument that \strong{glmnet} uses. Also, \strong{rules} can also set \code{penalty}
whereas \strong{xrf} uses an internal 5-fold cross-validation to determine it
(by default).
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.
}

\subsection{Other details}{
\subsection{Interpreting \code{mtry}}{

The \code{mtry} argument denotes the number of predictors that will be
randomly sampled at each split when creating tree models.

Some engines, such as \code{"xgboost"}, \code{"xrf"}, and \code{"lightgbm"}, interpret
their analogue to the \code{mtry} argument as the \emph{proportion} of predictors
that will be randomly sampled at each split rather than the \emph{count}. In
some settings, such as when tuning over preprocessors that influence the
number of predictors, this parameterization is quite
helpful—interpreting \code{mtry} as a proportion means that [0,1] is always
a valid range for that parameter, regardless of input data.

parsnip and its extensions accommodate this parameterization using the
\code{counts} argument: a logical indicating whether \code{mtry} should be
interpreted as the number of predictors that will be randomly sampled at
each split. \code{TRUE} indicates that \code{mtry} will be interpreted in its
sense as a count, \code{FALSE} indicates that the argument will be
interpreted in its sense as a proportion.

\code{mtry} is a main model argument for
\code{\link[=boost_tree]{boost_tree()}} and
\code{\link[=rand_forest]{rand_forest()}}, and thus should not have an
engine-specific interface. So, regardless of engine, \code{counts} defaults
to \code{TRUE}. For engines that support the proportion
interpretation—currently \code{"xgboost"}, \code{"xrf"} (via the rules package),
and \code{"lightgbm"} (via the bonsai package)—the user can pass the
\code{counts = FALSE} argument to \code{set_engine()} to supply \code{mtry} values
within [0,1].
}

\subsection{Early stopping}{

The \code{stop_iter()} argument allows the model to prematurely stop training
if the objective function does not improve within \code{early_stop}
iterations.

The best way to use this feature is in conjunction with an \emph{internal
validation set}. To do this, pass the \code{validation} parameter of
\code{\link[=xgb_train]{xgb_train()}} via the parsnip
\code{\link[=set_engine]{set_engine()}} function. This is the
proportion of the training set that should be reserved for measuring
performance (and stopping early).

If the model specification has \code{early_stop >= trees}, \code{early_stop} is
converted to \code{trees - 1} and a warning is issued.
}

}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{References}{
\itemize{
\item Friedman and Popescu. “Predictive learning via rule ensembles.” Ann.
Appl. Stat. 2 (3) 916- 954, September 2008
}
}
}
\keyword{internal}
