% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_reg_spark.R
\name{details_linear_reg_spark}
\alias{details_linear_reg_spark}
\title{Linear regression via spark}
\description{
\code{\link[sparklyr:ml_linear_regression]{sparklyr::ml_linear_regression()}} uses regularized least squares to fit
models with numeric outcomes.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: 0.0)
\item \code{mixture}: Proportion of Lasso Penalty (type: double, default: 0.0)
}

For \code{penalty}, the amount of regularization includes both the L1 penalty
(i.e., lasso) and the L2 penalty (i.e., ridge or weight decay). As for
\code{mixture}:
\itemize{
\item \code{mixture = 1} specifies a pure lasso model,
\item \code{mixture = 0} specifies a ridge regression model, and
\item \verb{0 < mixture < 1} specifies an elastic net model, interpolating
lasso and ridge.
}
}

\subsection{Translation from parsnip to the original package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{linear_reg(penalty = double(1), mixture = double(1)) \%>\% 
  set_engine("spark") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Regression Model Specification (regression)
## 
## Main Arguments:
##   penalty = double(1)
##   mixture = double(1)
## 
## Computational engine: spark 
## 
## Model fit template:
## sparklyr::ml_linear_regression(x = missing_arg(), formula = missing_arg(), 
##     weights = missing_arg(), reg_param = double(1), elastic_net_param = double(1))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip
will convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.

By default, \code{ml_linear_regression()} uses the argument
\code{standardization = TRUE} to center and scale the data.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.

Note that, for spark engines, the \code{case_weight} argument value should be
a character string to specify the column with the numeric case weights.
}

\subsection{Other details}{

For models created using the \code{"spark"} engine, there are several things
to consider.
\itemize{
\item Only the formula interface to via \code{fit()} is available; using
\code{fit_xy()} will generate an error.
\item The predictions will always be in a Spark table format. The names
will be the same as documented but without the dots.
\item There is no equivalent to factor columns in Spark tables so class
predictions are returned as character columns.
\item To retain the model object for a new R session (via \code{save()}), the
\code{model$fit} element of the parsnip object should be serialized via
\code{ml_save(object$fit)} and separately saved to disk. In a new
session, the object can be reloaded and reattached to the parsnip
object.
}
}

\subsection{References}{
\itemize{
\item Luraschi, J, K Kuo, and E Ruiz. 2019. \emph{Mastering Spark with R}.
O’Reilly Media
\item Hastie, T, R Tibshirani, and M Wainwright. 2015. \emph{Statistical
Learning with Sparsity}. CRC Press.
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
