% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim_linear.R
\name{discrim_linear}
\alias{discrim_linear}
\title{Linear discriminant analysis}
\usage{
discrim_linear(
  mode = "classification",
  penalty = NULL,
  regularization_method = NULL,
  engine = "MASS"
)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "classification".}

\item{penalty}{An non-negative number representing the amount of
regularization used by some of the engines.}

\item{regularization_method}{A character string for the type of regularized
estimation. Possible values are: "\code{diagonal}", "\code{min_distance}",
"\code{shrink_cov}", and "\code{shrink_mean}" (\code{sparsediscrim} engine only).}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{discrim_linear()} defines a model that estimates a multivariate
distribution for the predictors separately for the data in each class
(usually Gaussian with a common covariance matrix). Bayes' theorem is used
to compute the probability of each class, given the predictor values. This
function can fit classification models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("discrim_linear")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("discrim_linear")}
}
