% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinom_reg.R
\name{multinom_reg}
\alias{multinom_reg}
\title{Multinomial regression}
\usage{
multinom_reg(
  mode = "classification",
  engine = "nnet",
  penalty = NULL,
  mixture = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Possible engines are listed below. The default for this
model is \code{"nnet"}.}

\item{penalty}{A non-negative number representing the total
amount of regularization (specific engines only).
For \code{keras} models, this corresponds to purely L2 regularization
(aka weight decay) while the other models can be a combination
of L1 and L2 (depending on the value of \code{mixture}).}

\item{mixture}{A number between zero and one (inclusive) giving the
proportion of L1 regularization (i.e. lasso) in the model.
\itemize{
\item \code{mixture = 1} specifies a pure lasso model,
\item \code{mixture = 0}  specifies a ridge regression model, and
\item \verb{0 < mixture < 1} specifies an elastic net model, interpolating lasso and ridge.
}

Available for specific engines only.}
}
\description{
\code{multinom_reg()} defines a model that uses linear predictors to predict
multiclass data using the multinomial distribution. This function can fit
classification models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("multinom_reg")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

Each of the arguments in this function other than \code{mode} and \code{engine} are
captured as \link[rlang:topic-quosure]{quosures}. To pass values
programmatically, use the \link[rlang:injection-operator]{injection operator} like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{value <- 1
multinom_reg(argument = !!value)
}\if{html}{\out{</div>}}

This model fits a classification model for multiclass outcomes; for
binary outcomes, see \code{\link[=logistic_reg]{logistic_reg()}}.
}
\examples{
show_engines("multinom_reg")

multinom_reg()
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("multinom_reg")}
}
