% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collision_force.R
\docType{data}
\name{collision_force}
\alias{collision_force}
\title{Models particles as circles with a given radius and pushes overlapping particles apart}
\description{
This force pushes overlapping particles apart by assigning a radius to each
particle, treating them as circles, and searches for overlaps through an
optimised quad tree algorithm.
}
\section{Training parameters}{

The following parameters defines the training of the force and can be passed
along a call to \code{\link[=wield]{wield()}}
\itemize{
\item \code{strength} : A dampening of the repulsion between overlapping circles. This
allows the force to iterate towards the optimal solution through iterative
relaxation. Should be a number between 0 and 1. Defaults to 0.7
\item \code{radius} : The radius of each particle. Defaults to 1 (\emph{tidy eval})
\item \code{n_iter} : The number of iterations to perform in the iterative relaxation.
Defaults to 1.
}
}

\seealso{
Other forces: 
\code{\link{center_force}},
\code{\link{field_force}},
\code{\link{link_force}},
\code{\link{manybody_force}},
\code{\link{map_force}},
\code{\link{mean_force}},
\code{\link{random_force}},
\code{\link{reset_force}},
\code{\link{trap_force}},
\code{\link{x_force}},
\code{\link{y_force}}
}
\concept{forces}
\keyword{datasets}
