% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_permutation}
\alias{plot_permutation}
\title{Plot permutation tests}
\usage{
plot_permutation(
  permutations,
  .plot = c("information", "nclusters", "nreduced"),
  labeller = "target information:",
  perm_color = "#56B4EA",
  obs_color = "#CC78A8",
  geom = ggplot2::geom_density
)
}
\arguments{
\item{permutations}{a \code{tibble}, the result of \code{\link[=test_permutation]{test_permutation()}}}

\item{.plot}{the variable to plot: observed information, the number of
clusters created, or the number of observed variables reduced}

\item{labeller}{the facet label}

\item{perm_color}{the color of the permutation fill}

\item{obs_color}{the color of the observed statistic line}

\item{geom}{the \code{geom} to use. The default is \code{geom_density}.}
}
\value{
a ggplot
}
\description{
\code{plot_permutation()} takes the results of \code{\link[=test_permutation]{test_permutation()}} and plots the
distribution of permuted partitions compared to the observed partition.
}
\examples{
set.seed(123)
df <- simulate_block_data(c(3, 4, 5), lower_corr = .4, upper_corr = .6, n = 100)

test_permutation(df, partitioner = part_pc1(), nperm = 5) \%>\%
  plot_permutation("nclusters")

}
