% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappings.R
\name{filter_reduced}
\alias{filter_reduced}
\alias{unnest_reduced}
\title{Filter the reduced mappings}
\usage{
filter_reduced(.partition)

unnest_reduced(.partition)
}
\arguments{
\item{.partition}{a \code{partition} object}
}
\value{
a \code{tibble} with mapping key
}
\description{
\code{filter_reduced()} and \code{unnest_reduced()} are convenience functions to
quickly retrieve the mappings for only the reduced variables.
\code{filter_reduced()} returns a nested \code{tibble} while \code{unnest_reduced()} unnests
it.
}
\examples{
set.seed(123)
df <- simulate_block_data(c(3, 4, 5), lower_corr = .4, upper_corr = .6, n = 100)
# fit partition
prt <- partition(df, threshold = .6)


# A tibble: 3 x 4
filter_reduced(prt)

# A tibble: 9 x 4
unnest_reduced(prt)

}
