% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_series.R
\name{region_series}
\alias{region_series}
\title{Extract a time series of climate variables for a region}
\usage{
region_series(
  time_bp = NULL,
  bio_variables,
  dataset,
  path_to_nc = NULL,
  ext = NULL,
  crop = NULL
)
}
\arguments{
\item{time_bp}{time slices in years before present (negative values represent
time before present, positive values time in the future). This parameter can
be a vector of times (the slices need
to exist in the dataset), a list with a min and max element setting the
range of values, or left to NULL to retrieve all time steps.
To check which slices are available, you can use
\code{\link[=get_time_steps]{get_time_steps()}}.}

\item{bio_variables}{vector of names of variables to be extracted}

\item{dataset}{string defining the dataset to use. If set to "custom",
then a single nc file is used from "path_to_nc"}

\item{path_to_nc}{the path to the custom nc file containing the palaeoclimate
reconstructions. All the variables of interest need to be included in
this file.}

\item{ext}{an extent, coded as numeric vector (length=4;
order= xmin, xmax, ymin, ymax) or a \link[terra:SpatExtent-class]{terra::SpatExtent} object. If NULL,
the full extent of the reconstruction is given.}

\item{crop}{a polygon used to crop the reconstructions (e.g. the outline
of a continental mass). A \code{\link[sf:st]{sf::sfg}} or a \link[terra:SpatVector-class]{terra::SpatVector} object
is used to define the polygon.}
}
\value{
a
\code{\link[terra:SpatRaster-class]{terra::SpatRasterDataset}} object, with
each variable as a sub-dataset.
}
\description{
This function extracts a time series of one or more climate variables for
a given
dataset covering a region (or the whole world). The function returns a
\code{\link[terra:SpatRaster-class]{terra::SpatRasterDataset}} object, with
each variable as a sub-dataset.
}
