% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{wku_to_pno}
\alias{wku_to_pno}
\title{Get Patient Number from WKU}
\usage{
wku_to_pno(wku)
}
\arguments{
\item{wku}{character vector containing patent WKUs}
}
\value{
character vector containing patent numbers
}
\description{
Convert WKU identifier provided in bulk patent files to patent number
used in most sources. The References provided in bulk patent files are
also in patent number format, not in WKU format.
}
\examples{
# convert sample WKUs to patent number and print
sample_wku <- c("RE028671", "03930271")
print(wku_to_pno(sample_wku))
}
