% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active_snw_functions.R
\name{active_snw_search}
\alias{active_snw_search}
\title{Perform Active Subnetwork Search}
\usage{
active_snw_search(input_for_search, pin_path, snws_file = "active_snws",
  dir_for_parallel_run = NULL, score_quan_thr = 0.8,
  sig_gene_thr = 10, search_method = "GR", silent_option = TRUE,
  use_all_positives = FALSE, geneInitProbs = 0.1, saTemp0 = 1,
  saTemp1 = 0.01, saIter = 10000, gaPop = 400, gaIter = 10000,
  gaThread = 5, gaMut = 0, grMaxDepth = 1, grSearchDepth = 1,
  grOverlap = 0.5, grSubNum = 1000)
}
\arguments{
\item{input_for_search}{input the input data that active subnetwork search uses. The input
must be a data frame containing at least these three columns: \describe{
  \item{describe}{HGNC Gene Symbol}
  \item{P_VALUE}{p value obtained through a test, e.g. differential expression/methylation}
}}

\item{pin_path}{path to the Protein Interaction Network (PIN) file used in
the analysis}

\item{snws_file}{name for active subnetwork search output data}

\item{dir_for_parallel_run}{directory for parallel run iteration.
Only used in the wrapper function (see ?run_pathfindR) (Default = NULL)}

\item{score_quan_thr}{active subnetwork score quantile threshold (Default = 0.80)}

\item{sig_gene_thr}{threshold for minimum number of significant genes (Default = 10)}

\item{search_method}{algorithm to use when performing active subnetwork
search. Options are greedy search (GR), simulated annealing (SA) or genetic
algorithm (GA) for the search (Default = GR).}

\item{silent_option}{boolean value indicating whether to print the messages to the console (FALSE)
or print to a file (TRUE) during active subnetwork search (default = TRUE). This option was added
because during parallel runs, the console messages get mixed up.}

\item{use_all_positives}{if TRUE: in GA, adds an individual with all positive
nodes. In SA, initializes candidate solution with all positive nodes. (Default = FALSE)}

\item{geneInitProbs}{For SA and GA, probability of adding a gene in initial solution (Default = 0.1)}

\item{saTemp0}{Initial temperature for SA (Default = 1.0)}

\item{saTemp1}{Final temperature for SA (Default = 0.01)}

\item{saIter}{Iteration number for SA (Default = 10000)}

\item{gaPop}{Population size for GA (Default = 400)}

\item{gaIter}{Iteration number for GA (Default = 200)}

\item{gaThread}{Number of threads to be used in GA (Default = 5)}

\item{gaMut}{For GA, applies mutation with given mutation rate (Default = 0, i.e. mutation off)}

\item{grMaxDepth}{Sets max depth in greedy search, 0 for no limit (Default = 1)}

\item{grSearchDepth}{Search depth in greedy search (Default = 1)}

\item{grOverlap}{Overlap threshold for results of greedy search (Default = 0.5)}

\item{grSubNum}{Number of subnetworks to be presented in the results (Default = 1000)}
}
\value{
A list of genes in every identified active subnetwork that has a score greater than
the `score_quan_thr`th quantile and that has at least `sig_gene_thr` affected genes.
}
\description{
Perform Active Subnetwork Search
}
\examples{
\dontrun{
active_snw_search(input_for_search, pin_path = "path/to/PIN", search_method = "GR")
active_snw_search(input_for_search, pin_path = "path/to/PIN",
search_method = "SA", saTemp0 = 2, saTemp1 = 0.05)
}
}
