% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{input_testing}
\alias{input_testing}
\title{Input Testing}
\usage{
input_testing(input, p_val_threshold = 0.05)
}
\arguments{
\item{input}{the input data that pathfindR uses. The input must be a data
  frame with three columns: \enumerate{
  \item Gene Symbol (Gene Symbol)
  \item Change value, e.g. log(fold change) (OPTIONAL)
  \item p value, e.g. adjusted p value associated with differential expression
}}

\item{p_val_threshold}{the p value threshold to use when filtering
the input data frame. Must a numeric value between 0 and 1. (default = 0.05)}
}
\value{
Only checks if the input and the threshold follows the required
  specifications.
}
\description{
Input Testing
}
\examples{
input_testing(RA_input, 0.05)
}
\seealso{
See \code{\link{run_pathfindR}} for the wrapper function of the
  pathfindR workflow
}
