/*
 * Decompiled with CFR 0.152.
 */
package ActiveSubnetworkSearchMisc;

import ActiveSubnetworkSearchAlgorithms.ActiveSubnetworkSearch;
import ActiveSubnetworkSearchMisc.Gaussian;
import ActiveSubnetworkSearchMisc.Subnetwork;
import ActiveSubnetworkSearchMisc.ZStatistics;
import Application.Parameters;
import Network.Node;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScoreCalculations {
    private HashMap<Node, Double> nodeToPValueMap;
    private HashMap<Node, Double> nodeToZScoreMap;
    private final ArrayList<Node> networkNodeList;
    private double[] samplingScoreMeans;
    private double[] samplingScoreStds;
    private double[] samplingScoreMins;
    private double[] samplingScoreMaxs;
    private double MIN_SIG = 1.0E-13;
    private double MAX_SIG = 1.0 - this.MIN_SIG;

    public ScoreCalculations(ArrayList<AbstractMap.SimpleEntry<String, Double>> namePValuePairList) {
        this.networkNodeList = ActiveSubnetworkSearch.networkNodeList;
        this.fillNodeToPValueMap(namePValuePairList);
        this.process();
    }

    private void fillNodeToPValueMap(ArrayList<AbstractMap.SimpleEntry<String, Double>> namePValuePairList) {
        this.nodeToPValueMap = new HashMap();
        int geneFromExperimentNotExisingInNetwork = 0;
        for (AbstractMap.SimpleEntry<String, Double> entry : namePValuePairList) {
            Node node = new Node(entry.getKey());
            if (this.networkNodeList.contains(node)) {
                double pValue = entry.getValue();
                if (pValue < this.MIN_SIG) {
                    pValue = this.MIN_SIG;
                } else if (pValue > this.MAX_SIG) {
                    pValue = this.MAX_SIG;
                }
                double d = this.nodeToPValueMap.get(node) == null ? 1.0 : this.nodeToPValueMap.get(node);
                double existingPValue = d;
                if (!(pValue < existingPValue)) continue;
                this.nodeToPValueMap.put(node, pValue);
                continue;
            }
            ++geneFromExperimentNotExisingInNetwork;
        }
        System.out.println(this.nodeToPValueMap);
        if (geneFromExperimentNotExisingInNetwork > 0) {
            Logger.getLogger(ScoreCalculations.class.getName()).log(Level.WARNING, "{0} genes in experiment file does not exist in the network", geneFromExperimentNotExisingInNetwork);
        }
        for (Node node : this.networkNodeList) {
            if (this.nodeToPValueMap.containsKey(node)) continue;
            this.nodeToPValueMap.put(node, Parameters.pForNonSignificantNodes);
        }
    }

    public void process() {
        boolean tmpPenaltyForSize = Parameters.penaltyForSize;
        Parameters.penaltyForSize = false;
        this.calculateZScores();
        this.calculateMeanAndStdForMonteCarlo();
        Parameters.penaltyForSize = tmpPenaltyForSize;
    }

    public Double getPValue(Node node) {
        return this.nodeToPValueMap.get(node);
    }

    public Double getZScore(Node node) {
        return this.nodeToZScoreMap.get(node);
    }

    private void calculateZScores() {
        this.nodeToZScoreMap = new HashMap();
        for (Node node : this.networkNodeList) {
            double pValue = this.nodeToPValueMap.get(node);
            this.nodeToZScoreMap.put(node, ZStatistics.oneMinusNormalCDFInverse(pValue));
        }
    }

    private void calculateMeanAndStdForMonteCarlo() {
        int numberOfNodes = this.networkNodeList.size();
        this.samplingScoreMeans = new double[numberOfNodes + 1];
        this.samplingScoreStds = new double[numberOfNodes + 1];
        this.samplingScoreMins = new double[numberOfNodes + 1];
        this.samplingScoreMaxs = new double[numberOfNodes + 1];
        double[] samplingScoreSums = new double[numberOfNodes + 1];
        double[] samplingScoreSquareSums = new double[numberOfNodes + 1];
        for (int i = 0; i < numberOfNodes + 1; ++i) {
            samplingScoreSums[i] = 0.0;
            samplingScoreSquareSums[i] = 0.0;
            this.samplingScoreMins[i] = Double.MAX_VALUE;
            this.samplingScoreMaxs[i] = Double.MIN_VALUE;
        }
        int numberOfTrials = 2000;
        ArrayList<Node> nodeListForSampling = new ArrayList<Node>(this.networkNodeList);
        ArrayList<Node> significantNodesList = new ArrayList<Node>();
        ArrayList<Node> nonsignificantNodesList = new ArrayList<Node>();
        for (Node node : this.networkNodeList) {
            if (this.nodeToZScoreMap.get(node) > 0.0) {
                significantNodesList.add(node);
                continue;
            }
            nonsignificantNodesList.add(node);
        }
        for (int trial = 0; trial < numberOfTrials; ++trial) {
            Collections.shuffle(nodeListForSampling);
            double zSum = 0.0;
            int numberOfNodesInSubnetwork = 0;
            for (Node node : nodeListForSampling) {
                double score = this.calculateScoreOfSubnetwork(++numberOfNodesInSubnetwork, zSum += this.nodeToZScoreMap.get(node).doubleValue(), false);
                int n = numberOfNodesInSubnetwork;
                samplingScoreSums[n] = samplingScoreSums[n] + score;
                int n2 = numberOfNodesInSubnetwork;
                samplingScoreSquareSums[n2] = samplingScoreSquareSums[n2] + score * score;
                if (score < this.samplingScoreMins[numberOfNodesInSubnetwork]) {
                    this.samplingScoreMins[numberOfNodesInSubnetwork] = score;
                }
                if (!(score > this.samplingScoreMaxs[numberOfNodesInSubnetwork])) continue;
                this.samplingScoreMaxs[numberOfNodesInSubnetwork] = score;
            }
        }
        for (int i = 1; i <= numberOfNodes; ++i) {
            this.samplingScoreMeans[i] = samplingScoreSums[i] / (double)numberOfTrials;
            this.samplingScoreStds[i] = samplingScoreSquareSums[i] / (double)numberOfTrials - this.samplingScoreMeans[i] * this.samplingScoreMeans[i];
            this.samplingScoreStds[i] = Math.sqrt(this.samplingScoreStds[i] + 1.0E-7);
        }
    }

    public double calculateScoreOfSubnetwork(Subnetwork subnetwork, boolean subnetworkScoreNormalization) {
        return this.calculateScoreOfSubnetwork(subnetwork.getNodeList(), subnetworkScoreNormalization);
    }

    public double calculateScoreOfSubnetwork(ArrayList<Node> nodeList, boolean subnetworkScoreNormalization) {
        int numberOfNodes = nodeList.size();
        double zSum = 0.0;
        for (Node node : nodeList) {
            zSum += this.nodeToZScoreMap.get(node).doubleValue();
        }
        return this.calculateScoreOfSubnetwork(numberOfNodes, zSum, subnetworkScoreNormalization);
    }

    public double calculateScoreOfSubnetwork(int numberOfNodes, double zSum, boolean subnetworkScoreNormalization) {
        if (numberOfNodes == 1) {
            return 0.0;
        }
        double score = zSum / Math.sqrt(numberOfNodes);
        if (subnetworkScoreNormalization) {
            score = this.normalizeScore(score, numberOfNodes);
        }
        if (Parameters.penaltyForSize) {
            score = this.penaltyForSize(score, numberOfNodes);
        }
        return score;
    }

    private double normalizeScore(double score, int numberOfNodes) {
        return (score - this.samplingScoreMeans[numberOfNodes]) / this.samplingScoreStds[numberOfNodes];
    }

    private double penaltyForSize(double score, int numberOfNodes) {
        score = score * Gaussian.cdf(score, 100.0, 30.0) * 1000.0;
        return score;
    }
}

