% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{get_pin_file}
\alias{get_pin_file}
\title{Retrieve Organism-specific PIN data}
\usage{
get_pin_file(source = "BioGRID", org = "Homo_sapiens", path2pin, ...)
}
\arguments{
\item{source}{As of this version, this function is implemented to get data
from "BioGRID" only. This argument (and this wrapper function) was implemented
for future utility}

\item{org}{organism name. BioGRID naming requires underscores for spaces so
"Homo sapiens" becomes "Homo_sapiens", "Mus musculus" becomes "Mus_musculus"
etc. See \url{https://wiki.thebiogrid.org/doku.php/statistics} for a full
list of available organisms (default = "Homo_sapiens")}

\item{path2pin}{the path of the file to save the PIN data. By default, the
PIN data is saved in a temporary file}

\item{...}{additional arguments for \code{\link{get_biogrid_pin}}}
}
\value{
the path of the file in which the PIN data was saved. If
\code{path2pin} was not supplied by the user, the PIN data is saved in a
temporary file
}
\description{
Retrieve Organism-specific PIN data
}
\examples{
\dontrun{
pin_path <- get_pin_file()
}
}
