% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{visualize_term_interactions}
\alias{visualize_term_interactions}
\title{Visualize Interactions of Genes Involved in the Given Enriched Terms}
\usage{
visualize_term_interactions(result_df, pin_name_path)
}
\arguments{
\item{result_df}{Data frame of enrichment results. Must-have columns
are: "Term_Description", "Up_regulated" and "Down_regulated"}

\item{pin_name_path}{Name of the chosen PIN or path/to/PIN.sif. If PIN name,
must be one of c("Biogrid", "STRING", "GeneMania", "IntAct", "KEGG", "mmu_STRING"). If
path/to/PIN.sif, the file must comply with the PIN specifications. (Default = "Biogrid")}
}
\value{
Creates PNG files visualizing the interactions of genes involved
in the given enriched terms (annotated in the \code{result_df}) in the PIN used
for enrichment analysis (specified by \code{pin_name_path}). The PNG files are
saved in the folder "term_visualizations" under the current working directory.
}
\description{
Visualize Interactions of Genes Involved in the Given Enriched Terms
}
\details{
The following steps are performed for the visualization of interactions
of genes involved for each enriched term: \enumerate{
  \item shortest paths between all affected genes are determined (via \code{\link[igraph]{igraph}})
  \item the nodes of all shortest paths are merged
  \item the PIN is subsetted using the merged nodes (genes)
  \item using the PIN subset, the graph showing the interactions is generated
  \item the final graph is visualized using \code{\link[igraph]{igraph}}, colored by changed
  status (if provided), and is saved as a PNG file.
}
}
\examples{
\dontrun{
visualize_term_interactions(result_df, pin_name_path = "IntAct")
}
}
\seealso{
See \code{\link{visualize_terms}} for the wrapper function
  for creating enriched term diagrams. See \code{\link{run_pathfindR}} for the
  wrapper function of the pathfindR enrichment workflow.
}
