% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{ds_extract}
\alias{ds_extract}
\title{Execute an extract query}
\usage{
ds_extract(ds, subject_resource, columns, filters = NULL)
}
\arguments{
\item{ds}{The DataSource object containing the data to be queried.}

\item{subject_resource}{A string representing the type of FHIR resource to extract data from.}

\item{columns}{A named list of FHIRPath expressions that define the columns to include in the extract.}

\item{filters}{An optional sequence of FHIRPath expressions that can be evaluated against each resource
in the data set to determine whether it is included within the result. The expression must evaluate to a
Boolean value. Multiple filters are combined using AND logic.}
}
\value{
A Spark DataFrame containing the extracted data.
}
\description{
Executes an extract query over FHIR data. This type of query extracts specified columns from 
FHIR resources in a tabular format.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pc <- pathling_connect()
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples('ndjson'))
data_source \%>\% ds_extract('Patient',
     columns = c('gender', givenName='name.given'),
     filters = c('birthDate > @1950-01-01')
)
pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/fhirpath-query#extract}{Pathling documentation - Extract}

Other FHIRPath queries: 
\code{\link{ds_aggregate}()}
}
\concept{FHIRPath queries}
