% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/paths.R
\name{split_path}
\alias{split_path}
\title{Split a path into directory components}
\usage{
split_path(x = dir())
}
\arguments{
\item{x}{A character vector of file paths. Defaults to files in the
current directory.}
}
\value{
A named list of character vectors containing the split paths.
}
\description{
Splits a character vector of paths into directory components.  The opposite
of \code{\link[base]{file.path}}.
}
\note{
Paths are split on forward and back slashes, except for double forward
or back slashes at the start of (UNC) paths.  These are included in the first
element of that split path.
}
\examples{
(splits <- split_path(c(getwd(), "~", r_home())))
# Reverse the operation
sapply(splits, paste, collapse = "/")
}

