% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triplot.R
\name{triplot}
\alias{triplot}
\title{Plot a maxwell triangle}
\usage{
triplot(tridata, labels = TRUE, achro = TRUE, achrocol = "grey",
  achrosize = 0.8, cex.labels = 1, out.lwd = 1, out.lcol = "black",
  out.lty = 1, margins = c(1, 1, 2, 2), square = TRUE, ...)
}
\arguments{
\item{tridata}{(required) a data frame, possibly a result from the \code{trispace} .
function, containing values for the 'x' and 'y' coordinates as columns (labeled as such).}

\item{labels}{plot verticy labels? Defaults to \code{TRUE}.}

\item{achro}{should a point be plotted at the origin (defaults to \code{TRUE})?.}

\item{achrocol}{color of the point at the origin \code{achro = TRUE} (defaults to \code{'grey'}).}

\item{achrosize}{size of the point at the origin when \code{achro = TRUE} (defaults to 0.8).}

\item{cex.labels}{character expansion factor for category labels when \code{labels = TRUE}).}

\item{out.lwd, out.lcol, out.lty}{graphical parameters for the plot outline.}

\item{margins}{margins for the plot.}

\item{square}{logical. Should the aspect ratio of the plot be held to 1:1? 
(defaults to \code{TRUE})}

\item{...}{additional graphical options. See \code{\link{par}}.}
}
\description{
Produces a Maxwell triangle plot.
}
\examples{
\dontrun{
data(flowers)
vis.flowers <- vismodel(flowers, visual = 'apis')
tri.flowers <- colspace(vis.flowers, space = 'tri')
plot(tri.flowers)
}

}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\references{
Kelber A, Vorobyev M, Osorio D. (2003). Animal colour vision
   - behavioural tests and physiological concepts. Biological Reviews, 78,
   81 - 118.

Neumeyer C (1980) Simultaneous color contrast in the honeybee. 
 Journal of comparative physiology, 139(3), 165-176.
}
\keyword{internal}

