% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_delete_analysis}
\alias{quicksight_delete_analysis}
\title{Deletes an analysis from Amazon QuickSight}
\usage{
quicksight_delete_analysis(AwsAccountId, AnalysisId,
  RecoveryWindowInDays, ForceDeleteWithoutRecovery)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account where you want to delete an analysis.}

\item{AnalysisId}{[required] The ID of the analysis that you're deleting.}

\item{RecoveryWindowInDays}{A value that specifies the number of days that QuickSight waits before
it deletes the analysis. You can't use this parameter with the
\code{ForceDeleteWithoutRecovery} option in the same API call. The default
value is 30.}

\item{ForceDeleteWithoutRecovery}{This option defaults to the value \code{NoForceDeleteWithoutRecovery}. To
immediately delete the analysis, add the \code{ForceDeleteWithoutRecovery}
option. You can't restore an analysis after it's deleted.}
}
\description{
Deletes an analysis from Amazon QuickSight. You can optionally include a
recovery window during which you can restore the analysis. If you don't
specify a recovery window value, the operation defaults to 30 days.
QuickSight attaches a \code{DeletionTime} stamp to the response that
specifies the end of the recovery window. At the end of the recovery
window, QuickSight deletes the analysis permanently.

At any time before recovery window ends, you can use the
\code{RestoreAnalysis} API operation to remove the \code{DeletionTime} stamp and
cancel the deletion of the analysis. The analysis remains visible in the
API until it's deleted, so you can describe it but you can't make a
template from it.

An analysis that's scheduled for deletion isn't accessible in the
QuickSight console. To access it in the console, restore it. Deleting an
analysis doesn't delete the dashboards that you publish from it.
}
\section{Request syntax}{
\preformatted{svc$delete_analysis(
  AwsAccountId = "string",
  AnalysisId = "string",
  RecoveryWindowInDays = 123,
  ForceDeleteWithoutRecovery = TRUE|FALSE
)
}
}

\keyword{internal}
