% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_describe_analysis_schemes}
\alias{cloudsearch_describe_analysis_schemes}
\title{Gets the analysis schemes configured for a domain}
\usage{
cloudsearch_describe_analysis_schemes(DomainName, AnalysisSchemeNames,
  Deployed)
}
\arguments{
\item{DomainName}{[required] The name of the domain you want to describe.}

\item{AnalysisSchemeNames}{The analysis schemes you want to describe.}

\item{Deployed}{Whether to display the deployed configuration (\code{true}) or include any
pending changes (\code{false}). Defaults to \code{false}.}
}
\value{
A list with the following syntax:\preformatted{list(
  AnalysisSchemes = list(
    list(
      Options = list(
        AnalysisSchemeName = "string",
        AnalysisSchemeLanguage = "ar"|"bg"|"ca"|"cs"|"da"|"de"|"el"|"en"|"es"|"eu"|"fa"|"fi"|"fr"|"ga"|"gl"|"he"|"hi"|"hu"|"hy"|"id"|"it"|"ja"|"ko"|"lv"|"mul"|"nl"|"no"|"pt"|"ro"|"ru"|"sv"|"th"|"tr"|"zh-Hans"|"zh-Hant",
        AnalysisOptions = list(
          Synonyms = "string",
          Stopwords = "string",
          StemmingDictionary = "string",
          JapaneseTokenizationDictionary = "string",
          AlgorithmicStemming = "none"|"minimal"|"light"|"full"
        )
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active"|"FailedToValidate",
        PendingDeletion = TRUE|FALSE
      )
    )
  )
)
}
}
\description{
Gets the analysis schemes configured for a domain. An analysis scheme
defines language-specific text processing options for a \code{text} field.
Can be limited to specific analysis schemes by name. By default, shows
all analysis schemes and includes any pending changes to the
configuration. Set the \code{Deployed} option to \code{true} to show the active
configuration and exclude pending changes. For more information, see
\href{https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html}{Configuring Analysis Schemes}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_analysis_schemes(
  DomainName = "string",
  AnalysisSchemeNames = list(
    "string"
  ),
  Deployed = TRUE|FALSE
)
}
}

\keyword{internal}
