% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_describe_scaling_parameters}
\alias{cloudsearch_describe_scaling_parameters}
\title{Gets the scaling parameters configured for a domain}
\usage{
cloudsearch_describe_scaling_parameters(DomainName)
}
\arguments{
\item{DomainName}{[required]}
}
\value{
A list with the following syntax:\preformatted{list(
  ScalingParameters = list(
    Options = list(
      DesiredInstanceType = "search.m1.small"|"search.m1.large"|"search.m2.xlarge"|"search.m2.2xlarge"|"search.m3.medium"|"search.m3.large"|"search.m3.xlarge"|"search.m3.2xlarge"|"search.small"|"search.medium"|"search.large"|"search.xlarge"|"search.2xlarge",
      DesiredReplicationCount = 123,
      DesiredPartitionCount = 123
    ),
    Status = list(
      CreationDate = as.POSIXct(
        "2015-01-01"
      ),
      UpdateDate = as.POSIXct(
        "2015-01-01"
      ),
      UpdateVersion = 123,
      State = "RequiresIndexDocuments"|"Processing"|"Active"|"FailedToValidate",
      PendingDeletion = TRUE|FALSE
    )
  )
)
}
}
\description{
Gets the scaling parameters configured for a domain. A domain's scaling
parameters specify the desired search instance type and replication
count. For more information, see \href{https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html}{Configuring Scaling Options}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_scaling_parameters(
  DomainName = "string"
)
}
}

\keyword{internal}
