% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_job}
\alias{glue_get_job}
\title{Retrieves an existing job definition}
\usage{
glue_get_job(JobName)
}
\arguments{
\item{JobName}{[required] The name of the job definition to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Job = list(
    Name = "string",
    Description = "string",
    LogUri = "string",
    Role = "string",
    CreatedOn = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedOn = as.POSIXct(
      "2015-01-01"
    ),
    ExecutionProperty = list(
      MaxConcurrentRuns = 123
    ),
    Command = list(
      Name = "string",
      ScriptLocation = "string",
      PythonVersion = "string"
    ),
    DefaultArguments = list(
      "string"
    ),
    NonOverridableArguments = list(
      "string"
    ),
    Connections = list(
      Connections = list(
        "string"
      )
    ),
    MaxRetries = 123,
    AllocatedCapacity = 123,
    Timeout = 123,
    MaxCapacity = 123.0,
    WorkerType = "Standard"|"G.1X"|"G.2X",
    NumberOfWorkers = 123,
    SecurityConfiguration = "string",
    NotificationProperty = list(
      NotifyDelayAfter = 123
    ),
    GlueVersion = "string"
  )
)
}
}
\description{
Retrieves an existing job definition.
}
\section{Request syntax}{
\preformatted{svc$get_job(
  JobName = "string"
)
}
}

\keyword{internal}
