% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_list_iam_policy_assignments_for_user}
\alias{quicksight_list_iam_policy_assignments_for_user}
\title{Lists all the IAM policy assignments, including the Amazon Resource
Names (ARNs) for the IAM policies assigned to the specified user and
group or groups that the user belongs to}
\usage{
quicksight_list_iam_policy_assignments_for_user(AwsAccountId, UserName,
  NextToken, MaxResults, Namespace)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account that contains the assignments.}

\item{UserName}{[required] The name of the user.}

\item{NextToken}{The token for the next set of results, or null if there are no more
results.}

\item{MaxResults}{The maximum number of results to be returned per request.}

\item{Namespace}{[required] The namespace of the assignment.}
}
\value{
A list with the following syntax:\preformatted{list(
  ActiveAssignments = list(
    list(
      AssignmentName = "string",
      PolicyArn = "string"
    )
  ),
  RequestId = "string",
  NextToken = "string",
  Status = 123
)
}
}
\description{
Lists all the IAM policy assignments, including the Amazon Resource
Names (ARNs) for the IAM policies assigned to the specified user and
group or groups that the user belongs to.
}
\section{Request syntax}{
\preformatted{svc$list_iam_policy_assignments_for_user(
  AwsAccountId = "string",
  UserName = "string",
  NextToken = "string",
  MaxResults = 123,
  Namespace = "string"
)
}
}

\keyword{internal}
