% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_batch_get_workflows}
\alias{glue_batch_get_workflows}
\title{Returns a list of resource metadata for a given list of workflow names}
\usage{
glue_batch_get_workflows(Names, IncludeGraph)
}
\arguments{
\item{Names}{[required] A list of workflow names, which may be the names returned from the
\code{\link[=glue_list_workflows]{list_workflows}} operation.}

\item{IncludeGraph}{Specifies whether to include a graph when returning the workflow
resource metadata.}
}
\value{
A list with the following syntax:\preformatted{list(
  Workflows = list(
    list(
      Name = "string",
      Description = "string",
      DefaultRunProperties = list(
        "string"
      ),
      CreatedOn = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedOn = as.POSIXct(
        "2015-01-01"
      ),
      LastRun = list(
        Name = "string",
        WorkflowRunId = "string",
        PreviousRunId = "string",
        WorkflowRunProperties = list(
          "string"
        ),
        StartedOn = as.POSIXct(
          "2015-01-01"
        ),
        CompletedOn = as.POSIXct(
          "2015-01-01"
        ),
        Status = "RUNNING"|"COMPLETED"|"STOPPING"|"STOPPED"|"ERROR",
        ErrorMessage = "string",
        Statistics = list(
          TotalActions = 123,
          TimeoutActions = 123,
          FailedActions = 123,
          StoppedActions = 123,
          SucceededActions = 123,
          RunningActions = 123
        ),
        Graph = list(
          Nodes = list(
            list(
              Type = "CRAWLER"|"JOB"|"TRIGGER",
              Name = "string",
              UniqueId = "string",
              TriggerDetails = list(
                Trigger = list(
                  Name = "string",
                  WorkflowName = "string",
                  Id = "string",
                  Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
                  State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
                  Description = "string",
                  Schedule = "string",
                  Actions = list(
                    list(
                      JobName = "string",
                      Arguments = list(
                        "string"
                      ),
                      Timeout = 123,
                      SecurityConfiguration = "string",
                      NotificationProperty = list(
                        NotifyDelayAfter = 123
                      ),
                      CrawlerName = "string"
                    )
                  ),
                  Predicate = list(
                    Logical = "AND"|"ANY",
                    Conditions = list(
                      list(
                        LogicalOperator = "EQUALS",
                        JobName = "string",
                        State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
                        CrawlerName = "string",
                        CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
                      )
                    )
                  )
                )
              ),
              JobDetails = list(
                JobRuns = list(
                  list(
                    Id = "string",
                    Attempt = 123,
                    PreviousRunId = "string",
                    TriggerName = "string",
                    JobName = "string",
                    StartedOn = as.POSIXct(
                      "2015-01-01"
                    ),
                    LastModifiedOn = as.POSIXct(
                      "2015-01-01"
                    ),
                    CompletedOn = as.POSIXct(
                      "2015-01-01"
                    ),
                    JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
                    Arguments = list(
                      "string"
                    ),
                    ErrorMessage = "string",
                    PredecessorRuns = list(
                      list(
                        JobName = "string",
                        RunId = "string"
                      )
                    ),
                    AllocatedCapacity = 123,
                    ExecutionTime = 123,
                    Timeout = 123,
                    MaxCapacity = 123.0,
                    WorkerType = "Standard"|"G.1X"|"G.2X",
                    NumberOfWorkers = 123,
                    SecurityConfiguration = "string",
                    LogGroupName = "string",
                    NotificationProperty = list(
                      NotifyDelayAfter = 123
                    ),
                    GlueVersion = "string"
                  )
                )
              ),
              CrawlerDetails = list(
                Crawls = list(
                  list(
                    State = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED",
                    StartedOn = as.POSIXct(
                      "2015-01-01"
                    ),
                    CompletedOn = as.POSIXct(
                      "2015-01-01"
                    ),
                    ErrorMessage = "string",
                    LogGroup = "string",
                    LogStream = "string"
                  )
                )
              )
            )
          ),
          Edges = list(
            list(
              SourceId = "string",
              DestinationId = "string"
            )
          )
        )
      ),
      Graph = list(
        Nodes = list(
          list(
            Type = "CRAWLER"|"JOB"|"TRIGGER",
            Name = "string",
            UniqueId = "string",
            TriggerDetails = list(
              Trigger = list(
                Name = "string",
                WorkflowName = "string",
                Id = "string",
                Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
                State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
                Description = "string",
                Schedule = "string",
                Actions = list(
                  list(
                    JobName = "string",
                    Arguments = list(
                      "string"
                    ),
                    Timeout = 123,
                    SecurityConfiguration = "string",
                    NotificationProperty = list(
                      NotifyDelayAfter = 123
                    ),
                    CrawlerName = "string"
                  )
                ),
                Predicate = list(
                  Logical = "AND"|"ANY",
                  Conditions = list(
                    list(
                      LogicalOperator = "EQUALS",
                      JobName = "string",
                      State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
                      CrawlerName = "string",
                      CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
                    )
                  )
                )
              )
            ),
            JobDetails = list(
              JobRuns = list(
                list(
                  Id = "string",
                  Attempt = 123,
                  PreviousRunId = "string",
                  TriggerName = "string",
                  JobName = "string",
                  StartedOn = as.POSIXct(
                    "2015-01-01"
                  ),
                  LastModifiedOn = as.POSIXct(
                    "2015-01-01"
                  ),
                  CompletedOn = as.POSIXct(
                    "2015-01-01"
                  ),
                  JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
                  Arguments = list(
                    "string"
                  ),
                  ErrorMessage = "string",
                  PredecessorRuns = list(
                    list(
                      JobName = "string",
                      RunId = "string"
                    )
                  ),
                  AllocatedCapacity = 123,
                  ExecutionTime = 123,
                  Timeout = 123,
                  MaxCapacity = 123.0,
                  WorkerType = "Standard"|"G.1X"|"G.2X",
                  NumberOfWorkers = 123,
                  SecurityConfiguration = "string",
                  LogGroupName = "string",
                  NotificationProperty = list(
                    NotifyDelayAfter = 123
                  ),
                  GlueVersion = "string"
                )
              )
            ),
            CrawlerDetails = list(
              Crawls = list(
                list(
                  State = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED",
                  StartedOn = as.POSIXct(
                    "2015-01-01"
                  ),
                  CompletedOn = as.POSIXct(
                    "2015-01-01"
                  ),
                  ErrorMessage = "string",
                  LogGroup = "string",
                  LogStream = "string"
                )
              )
            )
          )
        ),
        Edges = list(
          list(
            SourceId = "string",
            DestinationId = "string"
          )
        )
      ),
      MaxConcurrentRuns = 123
    )
  ),
  MissingWorkflows = list(
    "string"
  )
)
}
}
\description{
Returns a list of resource metadata for a given list of workflow names.
After calling the \code{\link[=glue_list_workflows]{list_workflows}} operation, you
can call this operation to access the data to which you have been
granted permissions. This operation supports all IAM permissions,
including permission conditions that uses tags.
}
\section{Request syntax}{
\preformatted{svc$batch_get_workflows(
  Names = list(
    "string"
  ),
  IncludeGraph = TRUE|FALSE
)
}
}

\keyword{internal}
