% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_batch_put_document}
\alias{kendra_batch_put_document}
\title{Adds one or more documents to an index}
\usage{
kendra_batch_put_document(
  IndexId,
  RoleArn = NULL,
  Documents,
  CustomDocumentEnrichmentConfiguration = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index to add the documents to. You need to create
the index first using the \code{\link[=kendra_create_index]{create_index}} API.}

\item{RoleArn}{The Amazon Resource Name (ARN) of a role that is allowed to run the
\code{\link[=kendra_batch_put_document]{batch_put_document}} API. For more
information, see \href{https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html}{IAM Roles for Amazon Kendra}.}

\item{Documents}{[required] One or more documents to add to the index.

Documents have the following file size limits.
\itemize{
\item 5 MB total size for inline documents
\item 50 MB total size for files from an S3 bucket
\item 5 MB extracted text for any file
}

For more information about file size and transaction per second quotas,
see \href{https://docs.aws.amazon.com/kendra/latest/dg/quotas.html}{Quotas}.}

\item{CustomDocumentEnrichmentConfiguration}{Configuration information for altering your document metadata and
content during the document ingestion process when you use the
\code{\link[=kendra_batch_put_document]{batch_put_document}} API.

For more information on how to create, modify and delete document
metadata, or make other content alterations when you ingest documents
into Amazon Kendra, see \href{https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html}{Customizing document metadata during the ingestion process}.}
}
\description{
Adds one or more documents to an index.

See \url{https://paws-r.github.io/docs/kendra/batch_put_document.html} for full documentation.
}
\keyword{internal}
