% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_create_application}
\alias{kinesisanalytics_create_application}
\title{This documentation is for version 1 of the Amazon Kinesis Data Analytics
API, which only supports SQL applications}
\usage{
kinesisanalytics_create_application(
  ApplicationName,
  ApplicationDescription = NULL,
  Inputs = NULL,
  Outputs = NULL,
  CloudWatchLoggingOptions = NULL,
  ApplicationCode = NULL,
  Tags = NULL
)
}
\arguments{
\item{ApplicationName}{[required] Name of your Amazon Kinesis Analytics application (for example,
\code{sample-app}).}

\item{ApplicationDescription}{Summary description of the application.}

\item{Inputs}{Use this parameter to configure the application input.

You can configure your application to receive input from a single
streaming source. In this configuration, you map this streaming source
to an in-application stream that is created. Your application code can
then query the in-application stream like a table (you can think of it
as a constantly updating table).

For the streaming source, you provide its Amazon Resource Name (ARN) and
format of data on the stream (for example, JSON, CSV, etc.). You also
must provide an IAM role that Amazon Kinesis Analytics can assume to
read this stream on your behalf.

To create the in-application stream, you need to specify a schema to
transform your data into a schematized version used in SQL. In the
schema, you provide the necessary mapping of the data elements in the
streaming source to record columns in the in-app stream.}

\item{Outputs}{You can configure application output to write data from any of the
in-application streams to up to three destinations.

These destinations can be Amazon Kinesis streams, Amazon Kinesis
Firehose delivery streams, AWS Lambda destinations, or any combination
of the three.

In the configuration, you specify the in-application stream name, the
destination stream or Lambda function Amazon Resource Name (ARN), and
the format to use when writing data. You must also provide an IAM role
that Amazon Kinesis Analytics can assume to write to the destination
stream or Lambda function on your behalf.

In the output configuration, you also provide the output stream or
Lambda function ARN. For stream destinations, you provide the format of
data in the stream (for example, JSON, CSV). You also must provide an
IAM role that Amazon Kinesis Analytics can assume to write to the stream
or Lambda function on your behalf.}

\item{CloudWatchLoggingOptions}{Use this parameter to configure a CloudWatch log stream to monitor
application configuration errors. For more information, see \href{https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html}{Working with Amazon CloudWatch Logs}.}

\item{ApplicationCode}{One or more SQL statements that read input data, transform it, and
generate output. For example, you can write a SQL statement that reads
data from one in-application stream, generates a running average of the
number of advertisement clicks by vendor, and insert resulting rows in
another in-application stream using pumps. For more information about
the typical pattern, see \href{https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html}{Application Code}.

You can provide such series of SQL statements, where output of one
statement can be used as the input for the next statement. You store
intermediate results by creating in-application streams and pumps.

Note that the application code must create the streams with names
specified in the \code{Outputs}. For example, if your \code{Outputs} defines
output streams named \code{ExampleOutputStream1} and \code{ExampleOutputStream2},
then your application code must create these streams.}

\item{Tags}{A list of one or more tags to assign to the application. A tag is a
key-value pair that identifies an application. Note that the maximum
number of application tags includes system tags. The maximum number of
user-defined application tags is 50. For more information, see \href{https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html}{Using Tagging}.}
}
\description{
This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.

See \url{https://paws-r.github.io/docs/kinesisanalytics/create_application.html} for full documentation.
}
\keyword{internal}
