% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_start_asset_bundle_import_job}
\alias{quicksight_start_asset_bundle_import_job}
\title{Starts an Asset Bundle import job}
\usage{
quicksight_start_asset_bundle_import_job(
  AwsAccountId,
  AssetBundleImportJobId,
  AssetBundleImportSource,
  OverrideParameters = NULL,
  FailureAction = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account to import assets into.}

\item{AssetBundleImportJobId}{[required] The ID of the job. This ID is unique while the job is running. After the
job is completed, you can reuse this ID for another job.}

\item{AssetBundleImportSource}{[required] The source of the asset bundle zip file that contains the data that you
want to import. The file must be in \code{QUICKSIGHT_JSON} format.}

\item{OverrideParameters}{Optional overrides to be applied to the resource configuration before
import.}

\item{FailureAction}{The failure action for the import job.

If you choose \code{ROLLBACK}, failed import jobs will attempt to undo any
asset changes caused by the failed job.

If you choose \code{DO_NOTHING}, failed import jobs will not attempt to roll
back any asset changes caused by the failed job, possibly keeping the
Amazon QuickSight account in an inconsistent state.}
}
\description{
Starts an Asset Bundle import job.

See \url{https://www.paws-r-sdk.com/docs/quicksight_start_asset_bundle_import_job/} for full documentation.
}
\keyword{internal}
