% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_account_subscription}
\alias{quicksight_create_account_subscription}
\title{Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight
Q}
\usage{
quicksight_create_account_subscription(
  Edition,
  AuthenticationMethod,
  AwsAccountId,
  AccountName,
  NotificationEmail,
  ActiveDirectoryName = NULL,
  Realm = NULL,
  DirectoryId = NULL,
  AdminGroup = NULL,
  AuthorGroup = NULL,
  ReaderGroup = NULL,
  FirstName = NULL,
  LastName = NULL,
  EmailAddress = NULL,
  ContactNumber = NULL
)
}
\arguments{
\item{Edition}{[required] The edition of Amazon QuickSight that you want your account to have.
Currently, you can choose from \code{ENTERPRISE} or \code{ENTERPRISE_AND_Q}.

If you choose \code{ENTERPRISE_AND_Q}, the following parameters are required:
\itemize{
\item \code{FirstName}
\item \code{LastName}
\item \code{EmailAddress}
\item \code{ContactNumber}
}}

\item{AuthenticationMethod}{[required] The method that you want to use to authenticate your Amazon QuickSight
account.

If you choose \code{ACTIVE_DIRECTORY}, provide an \code{ActiveDirectoryName} and
an \code{AdminGroup} associated with your Active Directory.

If you choose \code{IAM_IDENTITY_CENTER}, provide an \code{AdminGroup} associated
with your IAM Identity Center account.}

\item{AwsAccountId}{[required] The Amazon Web Services account ID of the account that you're using to
create your Amazon QuickSight account.}

\item{AccountName}{[required] The name of your Amazon QuickSight account. This name is unique over all
of Amazon Web Services, and it appears only when users sign in. You
can't change \code{AccountName} value after the Amazon QuickSight account is
created.}

\item{NotificationEmail}{[required] The email address that you want Amazon QuickSight to send notifications
to regarding your Amazon QuickSight account or Amazon QuickSight
subscription.}

\item{ActiveDirectoryName}{The name of your Active Directory. This field is required if
\code{ACTIVE_DIRECTORY} is the selected authentication method of the new
Amazon QuickSight account.}

\item{Realm}{The realm of the Active Directory that is associated with your Amazon
QuickSight account. This field is required if \code{ACTIVE_DIRECTORY} is the
selected authentication method of the new Amazon QuickSight account.}

\item{DirectoryId}{The ID of the Active Directory that is associated with your Amazon
QuickSight account.}

\item{AdminGroup}{The admin group associated with your Active Directory or IAM Identity
Center account. This field is required if \code{ACTIVE_DIRECTORY} or
\code{IAM_IDENTITY_CENTER} is the selected authentication method of the new
Amazon QuickSight account.

For more information about using IAM Identity Center in Amazon
QuickSight, see \href{https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html}{Using IAM Identity Center with Amazon QuickSight Enterprise Edition}
in the Amazon QuickSight User Guide. For more information about using
Active Directory in Amazon QuickSight, see \href{https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html}{Using Active Directory with Amazon QuickSight Enterprise Edition}
in the Amazon QuickSight User Guide.}

\item{AuthorGroup}{The author group associated with your Active Directory or IAM Identity
Center account.

For more information about using IAM Identity Center in Amazon
QuickSight, see \href{https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html}{Using IAM Identity Center with Amazon QuickSight Enterprise Edition}
in the Amazon QuickSight User Guide. For more information about using
Active Directory in Amazon QuickSight, see \href{https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html}{Using Active Directory with Amazon QuickSight Enterprise Edition}
in the Amazon QuickSight User Guide.}

\item{ReaderGroup}{The reader group associated with your Active Directory or IAM Identity
Center account.

For more information about using IAM Identity Center in Amazon
QuickSight, see \href{https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html}{Using IAM Identity Center with Amazon QuickSight Enterprise Edition}
in the Amazon QuickSight User Guide. For more information about using
Active Directory in Amazon QuickSight, see \href{https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html}{Using Active Directory with Amazon QuickSight Enterprise Edition}
in the Amazon QuickSight User Guide.}

\item{FirstName}{The first name of the author of the Amazon QuickSight account to use for
future communications. This field is required if \code{ENTERPPRISE_AND_Q} is
the selected edition of the new Amazon QuickSight account.}

\item{LastName}{The last name of the author of the Amazon QuickSight account to use for
future communications. This field is required if \code{ENTERPPRISE_AND_Q} is
the selected edition of the new Amazon QuickSight account.}

\item{EmailAddress}{The email address of the author of the Amazon QuickSight account to use
for future communications. This field is required if \code{ENTERPPRISE_AND_Q}
is the selected edition of the new Amazon QuickSight account.}

\item{ContactNumber}{A 10-digit phone number for the author of the Amazon QuickSight account
to use for future communications. This field is required if
\code{ENTERPPRISE_AND_Q} is the selected edition of the new Amazon QuickSight
account.}
}
\description{
Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.

See \url{https://www.paws-r-sdk.com/docs/quicksight_create_account_subscription/} for full documentation.
}
\keyword{internal}
