% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_vpc_connection}
\alias{quicksight_update_vpc_connection}
\title{Updates a VPC connection}
\usage{
quicksight_update_vpc_connection(
  AwsAccountId,
  VPCConnectionId,
  Name,
  SubnetIds,
  SecurityGroupIds,
  DnsResolvers = NULL,
  RoleArn
)
}
\arguments{
\item{AwsAccountId}{[required] The Amazon Web Services account ID of the account that contains the VPC
connection that you want to update.}

\item{VPCConnectionId}{[required] The ID of the VPC connection that you're updating. This ID is a unique
identifier for each Amazon Web Services Region in an Amazon Web Services
account.}

\item{Name}{[required] The display name for the VPC connection.}

\item{SubnetIds}{[required] A list of subnet IDs for the VPC connection.}

\item{SecurityGroupIds}{[required] A list of security group IDs for the VPC connection.}

\item{DnsResolvers}{A list of IP addresses of DNS resolver endpoints for the VPC connection.}

\item{RoleArn}{[required] An IAM role associated with the VPC connection.}
}
\description{
Updates a VPC connection.

See \url{https://www.paws-r-sdk.com/docs/quicksight_update_vpc_connection/} for full documentation.
}
\keyword{internal}
