% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_create_subscription_request}
\alias{datazone_create_subscription_request}
\title{Creates a subscription request in Amazon DataZone}
\usage{
datazone_create_subscription_request(
  clientToken = NULL,
  domainIdentifier,
  requestReason,
  subscribedListings,
  subscribedPrincipals
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier that is provided to ensure the
idempotency of the request.}

\item{domainIdentifier}{[required] The ID of the Amazon DataZone domain in which the subscription request
is created.}

\item{requestReason}{[required] The reason for the subscription request.}

\item{subscribedListings}{[required] The published asset for which the subscription grant is to be created.}

\item{subscribedPrincipals}{[required] The Amazon DataZone principals for whom the subscription request is
created.}
}
\description{
Creates a subscription request in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_create_subscription_request/} for full documentation.
}
\keyword{internal}
