% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_request_cancel_workflow_execution}
\alias{swf_request_cancel_workflow_execution}
\title{Records a WorkflowExecutionCancelRequested event in the currently
running workflow execution identified by the given domain, workflowId,
and runId}
\usage{
swf_request_cancel_workflow_execution(domain, workflowId, runId)
}
\arguments{
\item{domain}{[required] The name of the domain containing the workflow execution to cancel.}

\item{workflowId}{[required] The workflowId of the workflow execution to cancel.}

\item{runId}{The runId of the workflow execution to cancel.}
}
\description{
Records a \code{WorkflowExecutionCancelRequested} event in the currently
running workflow execution identified by the given domain, workflowId,
and runId. This logically requests the cancellation of the workflow
execution as a whole. It is up to the decider to take appropriate
actions when it receives an execution history with this event.

If the runId isn't specified, the \code{WorkflowExecutionCancelRequested}
event is recorded in the history of the current open workflow execution
with the specified workflowId in the domain.

Because this action allows the workflow to properly clean up and
gracefully close, it should be used instead of
TerminateWorkflowExecution when possible.

\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item You cannot use an IAM policy to constrain this action's parameters.
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$request_cancel_workflow_execution(
  domain = "string",
  workflowId = "string",
  runId = "string"
)
}
}

\keyword{internal}
