% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_send_message_batch}
\alias{sqs_send_message_batch}
\title{Delivers up to ten messages to the specified queue}
\usage{
sqs_send_message_batch(QueueUrl, Entries)
}
\arguments{
\item{QueueUrl}{[required] The URL of the Amazon SQS queue to which batched messages are sent.

Queue URLs and names are case-sensitive.}

\item{Entries}{[required] A list of \code{<a>SendMessageBatchRequestEntry</a>} items.}
}
\description{
Delivers up to ten messages to the specified queue. This is a batch
version of \code{ <a>SendMessage</a>.} For a FIFO queue, multiple messages
within a single batch are enqueued in the order they are sent.
}
\details{
The result of sending each message is reported individually in the
response. Because the batch request can result in a combination of
successful and unsuccessful actions, you should check for batch errors
even when the call returns an HTTP status code of \code{200}.

The maximum allowed individual message size and the maximum total
payload size (the sum of the individual lengths of all of the batched
messages) are both 256 KB (262,144 bytes).

A message can include only XML, JSON, and unformatted text. The
following Unicode characters are allowed:

\code{#x9} \| \code{#xA} \| \code{#xD} \| \code{#x20} to \code{#xD7FF} \| \code{#xE000} to \code{#xFFFD} \|
\code{#x10000} to \code{#x10FFFF}

Any characters not included in this list will be rejected. For more
information, see the \href{http://www.w3.org/TR/REC-xml/#charsets}{W3C specification for characters}.

If you don't specify the \code{DelaySeconds} parameter for an entry, Amazon
SQS uses the default value for the queue.

Some actions take lists of parameters. These lists are specified using
the \code{param.n} notation. Values of \code{n} are integers starting from 1. For
example, a parameter list with two elements looks like this:

\code{&amp;Attribute.1=first}

\code{&amp;Attribute.2=second}
}
\section{Request syntax}{
\preformatted{svc$send_message_batch(
  QueueUrl = "string",
  Entries = list(
    list(
      Id = "string",
      MessageBody = "string",
      DelaySeconds = 123,
      MessageAttributes = list(
        list(
          StringValue = "string",
          BinaryValue = raw,
          StringListValues = list(
            "string"
          ),
          BinaryListValues = list(
            raw
          ),
          DataType = "string"
        )
      ),
      MessageDeduplicationId = "string",
      MessageGroupId = "string"
    )
  )
)
}
}

\keyword{internal}
