% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_remove_targets}
\alias{eventbridge_remove_targets}
\title{Removes the specified targets from the specified rule}
\usage{
eventbridge_remove_targets(Rule, EventBusName, Ids, Force)
}
\arguments{
\item{Rule}{[required] The name of the rule.}

\item{EventBusName}{The name of the event bus associated with the rule.}

\item{Ids}{[required] The IDs of the targets to remove from the rule.}

\item{Force}{If this is a managed rule, created by an AWS service on your behalf, you
must specify \code{Force} as \code{True} to remove targets. This parameter is
ignored for rules that are not managed rules. You can check whether a
rule is a managed rule by using \code{DescribeRule} or \code{ListRules} and
checking the \code{ManagedBy} field of the response.}
}
\description{
Removes the specified targets from the specified rule. When the rule is
triggered, those targets are no longer be invoked.
}
\details{
When you remove a target, when the associated rule triggers, removed
targets might continue to be invoked. Allow a short period of time for
changes to take effect.

This action can partially fail if too many requests are made at the same
time. If that happens, \code{FailedEntryCount} is non-zero in the response
and each entry in \code{FailedEntries} provides the ID of the failed target
and the error code.
}
\section{Request syntax}{
\preformatted{svc$remove_targets(
  Rule = "string",
  EventBusName = "string",
  Ids = list(
    "string"
  ),
  Force = TRUE|FALSE
)
}
}

\keyword{internal}
