% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mq_operations.R
\name{mq_update_broker}
\alias{mq_update_broker}
\title{Adds a pending configuration change to a broker}
\usage{
mq_update_broker(AutoMinorVersionUpgrade, BrokerId, Configuration,
  EngineVersion, HostInstanceType, Logs, SecurityGroups)
}
\arguments{
\item{AutoMinorVersionUpgrade}{Enables automatic upgrades to new minor versions for brokers, as Apache releases the versions. The automatic upgrades occur during the maintenance window of the broker or after a manual broker reboot.}

\item{BrokerId}{[required] The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard characters, or special characters.}

\item{Configuration}{A list of information about the configuration.}

\item{EngineVersion}{The version of the broker engine. For a list of supported engine versions, see https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html}

\item{HostInstanceType}{The host instance type of the broker to upgrade to. For a list of supported instance types, see https://docs.aws.amazon.com/amazon-mq/latest/developer-guide//broker.html#broker-instance-types}

\item{Logs}{Enables Amazon CloudWatch logging for brokers.}

\item{SecurityGroups}{The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.}
}
\description{
Adds a pending configuration change to a broker.
}
\section{Request syntax}{
\preformatted{svc$update_broker(
  AutoMinorVersionUpgrade = TRUE|FALSE,
  BrokerId = "string",
  Configuration = list(
    Id = "string",
    Revision = 123
  ),
  EngineVersion = "string",
  HostInstanceType = "string",
  Logs = list(
    Audit = TRUE|FALSE,
    General = TRUE|FALSE
  ),
  SecurityGroups = list(
    "string"
  )
)
}
}

\keyword{internal}
