% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_delete_message}
\alias{sqs_delete_message}
\title{Deletes the specified message from the specified queue}
\usage{
sqs_delete_message(QueueUrl, ReceiptHandle)
}
\arguments{
\item{QueueUrl}{[required] The URL of the Amazon SQS queue from which messages are deleted.

Queue URLs and names are case-sensitive.}

\item{ReceiptHandle}{[required] The receipt handle associated with the message to delete.}
}
\description{
Deletes the specified message from the specified queue. To select the message to delete, use the \code{ReceiptHandle} of the message (\emph{not} the \code{MessageId} which you receive when you send the message). Amazon SQS can delete a message from a queue even if a visibility timeout setting causes the message to be locked by another consumer. Amazon SQS automatically deletes messages left in a queue longer than the retention period configured for the queue.

See \url{https://paws-r.github.io/docs/sqs/delete_message.html} for full documentation.
}
\keyword{internal}
