% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_register_domain}
\alias{swf_register_domain}
\title{Registers a new domain}
\usage{
swf_register_domain(
  name,
  description = NULL,
  workflowExecutionRetentionPeriodInDays,
  tags = NULL
)
}
\arguments{
\item{name}{[required] Name of the domain to register. The name must be unique in the region
that the domain is registered in.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{U+0000`-`U+001f} | \verb{U+007f`-`U+009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{description}{A text description of the domain.}

\item{workflowExecutionRetentionPeriodInDays}{[required] The duration (in days) that records and histories of workflow executions
on the domain should be kept by the service. After the retention period,
the workflow execution isn't available in the results of visibility
calls.

If you pass the value \code{NONE} or \code{0} (zero), then the workflow execution
history isn't retained. As soon as the workflow execution completes, the
execution record and its history are deleted.

The maximum workflow execution retention period is 90 days. For more
information about Amazon SWF service limits, see: \href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html}{Amazon SWF Service Limits}
in the \emph{Amazon SWF Developer Guide}.}

\item{tags}{Tags to be added when registering a domain.

Tags may only contain unicode letters, digits, whitespace, or these
symbols: \verb{_ . : / = + - @}.}
}
\description{
Registers a new domain.

See \url{https://paws-r.github.io/docs/swf/register_domain.html} for full documentation.
}
\keyword{internal}
