# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sfn_service.R
NULL

#' Creates an activity
#'
#' @description
#' Creates an activity. An activity is a task that you write in any programming language and host on any machine that has access to Step Functions. Activities must poll Step Functions using the [`get_activity_task`][sfn_get_activity_task] API action and respond using `SendTask*` API actions. This function lets Step Functions know the existence of your activity and returns an identifier for use in a state machine and when polling from the activity.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_create_activity/](https://www.paws-r-sdk.com/docs/sfn_create_activity/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the activity to create. This name must be unique for your
#' Amazon Web Services account and region for 90 days. For more
#' information, see [Limits Related to State Machine
#' Executions](https://docs.aws.amazon.com/step-functions/latest/dg/service-quotas.html#service-limits-state-machine-executions)
#' in the *Step Functions Developer Guide*.
#' 
#' A name must *not* contain:
#' 
#' -   white space
#' 
#' -   brackets `< > { } [ ]`
#' 
#' -   wildcard characters `? *`
#' 
#' -   special characters `` \" # % \ ^ | ~ \` $ & , ; : / ``
#' 
#' -   control characters (`U+0000-001F`, `U+007F-009F`)
#' 
#' To enable logging with CloudWatch Logs, the name should only contain
#' 0-9, A-Z, a-z, - and _.
#' @param tags The list of tags to add to a resource.
#' 
#' An array of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
#' in the *Amazon Web Services Billing and Cost Management User Guide*, and
#' [Controlling Access Using IAM
#' Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
#' 
#' Tags may only contain Unicode letters, digits, white space, or these
#' symbols: `_ . : / = + - @@`.
#' @param encryptionConfiguration Settings to configure server-side encryption.
#'
#' @keywords internal
#'
#' @rdname sfn_create_activity
sfn_create_activity <- function(name, tags = NULL, encryptionConfiguration = NULL) {
  op <- new_operation(
    name = "CreateActivity",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$create_activity_input(name = name, tags = tags, encryptionConfiguration = encryptionConfiguration)
  output <- .sfn$create_activity_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$create_activity <- sfn_create_activity

#' Creates a state machine
#'
#' @description
#' Creates a state machine. A state machine consists of a collection of states that can do work (`Task` states), determine to which states to transition next (`Choice` states), stop an execution with an error (`Fail` states), and so on. State machines are specified using a JSON-based, structured language. For more information, see [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) in the Step Functions User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_create_state_machine/](https://www.paws-r-sdk.com/docs/sfn_create_state_machine/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the state machine.
#' 
#' A name must *not* contain:
#' 
#' -   white space
#' 
#' -   brackets `< > { } [ ]`
#' 
#' -   wildcard characters `? *`
#' 
#' -   special characters `` \" # % \ ^ | ~ \` $ & , ; : / ``
#' 
#' -   control characters (`U+0000-001F`, `U+007F-009F`)
#' 
#' To enable logging with CloudWatch Logs, the name should only contain
#' 0-9, A-Z, a-z, - and _.
#' @param definition &#91;required&#93; The Amazon States Language definition of the state machine. See [Amazon
#' States
#' Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to use for this state
#' machine.
#' @param type Determines whether a Standard or Express state machine is created. The
#' default is `STANDARD`. You cannot update the `type` of a state machine
#' once it has been created.
#' @param loggingConfiguration Defines what execution history events are logged and where they are
#' logged.
#' 
#' By default, the `level` is set to `OFF`. For more information see [Log
#' Levels](https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html)
#' in the Step Functions User Guide.
#' @param tags Tags to be added when creating a state machine.
#' 
#' An array of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
#' in the *Amazon Web Services Billing and Cost Management User Guide*, and
#' [Controlling Access Using IAM
#' Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
#' 
#' Tags may only contain Unicode letters, digits, white space, or these
#' symbols: `_ . : / = + - @@`.
#' @param tracingConfiguration Selects whether X-Ray tracing is enabled.
#' @param publish Set to `true` to publish the first version of the state machine during
#' creation. The default is `false`.
#' @param versionDescription Sets description about the state machine version. You can only set the
#' description if the `publish` parameter is set to `true`. Otherwise, if
#' you set `versionDescription`, but `publish` to `false`, this API action
#' throws `ValidationException`.
#' @param encryptionConfiguration Settings to configure server-side encryption.
#'
#' @keywords internal
#'
#' @rdname sfn_create_state_machine
sfn_create_state_machine <- function(name, definition, roleArn, type = NULL, loggingConfiguration = NULL, tags = NULL, tracingConfiguration = NULL, publish = NULL, versionDescription = NULL, encryptionConfiguration = NULL) {
  op <- new_operation(
    name = "CreateStateMachine",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$create_state_machine_input(name = name, definition = definition, roleArn = roleArn, type = type, loggingConfiguration = loggingConfiguration, tags = tags, tracingConfiguration = tracingConfiguration, publish = publish, versionDescription = versionDescription, encryptionConfiguration = encryptionConfiguration)
  output <- .sfn$create_state_machine_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$create_state_machine <- sfn_create_state_machine

#' Creates an alias for a state machine that points to one or two versions
#' of the same state machine
#'
#' @description
#' Creates an [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) for a state machine that points to one or two [versions](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) of the same state machine. You can set your application to call [`start_execution`][sfn_start_execution] with an alias and update the version the alias uses without changing the client's code.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_create_state_machine_alias/](https://www.paws-r-sdk.com/docs/sfn_create_state_machine_alias/) for full documentation.
#'
#' @param description A description for the state machine alias.
#' @param name &#91;required&#93; The name of the state machine alias.
#' 
#' To avoid conflict with version ARNs, don't use an integer in the name of
#' the alias.
#' @param routingConfiguration &#91;required&#93; The routing configuration of a state machine alias. The routing
#' configuration shifts execution traffic between two state machine
#' versions. `routingConfiguration` contains an array of `RoutingConfig`
#' objects that specify up to two state machine versions. Step Functions
#' then randomly choses which version to run an execution with based on the
#' weight assigned to each `RoutingConfig`.
#'
#' @keywords internal
#'
#' @rdname sfn_create_state_machine_alias
sfn_create_state_machine_alias <- function(description = NULL, name, routingConfiguration) {
  op <- new_operation(
    name = "CreateStateMachineAlias",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$create_state_machine_alias_input(description = description, name = name, routingConfiguration = routingConfiguration)
  output <- .sfn$create_state_machine_alias_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$create_state_machine_alias <- sfn_create_state_machine_alias

#' Deletes an activity
#'
#' @description
#' Deletes an activity.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_delete_activity/](https://www.paws-r-sdk.com/docs/sfn_delete_activity/) for full documentation.
#'
#' @param activityArn &#91;required&#93; The Amazon Resource Name (ARN) of the activity to delete.
#'
#' @keywords internal
#'
#' @rdname sfn_delete_activity
sfn_delete_activity <- function(activityArn) {
  op <- new_operation(
    name = "DeleteActivity",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$delete_activity_input(activityArn = activityArn)
  output <- .sfn$delete_activity_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$delete_activity <- sfn_delete_activity

#' Deletes a state machine
#'
#' @description
#' Deletes a state machine. This is an asynchronous operation. It sets the state machine's status to `DELETING` and begins the deletion process. A state machine is deleted only when all its executions are completed. On the next state transition, the state machine's executions are terminated.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_delete_state_machine/](https://www.paws-r-sdk.com/docs/sfn_delete_state_machine/) for full documentation.
#'
#' @param stateMachineArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine to delete.
#'
#' @keywords internal
#'
#' @rdname sfn_delete_state_machine
sfn_delete_state_machine <- function(stateMachineArn) {
  op <- new_operation(
    name = "DeleteStateMachine",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$delete_state_machine_input(stateMachineArn = stateMachineArn)
  output <- .sfn$delete_state_machine_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$delete_state_machine <- sfn_delete_state_machine

#' Deletes a state machine alias
#'
#' @description
#' Deletes a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_delete_state_machine_alias/](https://www.paws-r-sdk.com/docs/sfn_delete_state_machine_alias/) for full documentation.
#'
#' @param stateMachineAliasArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine alias to delete.
#'
#' @keywords internal
#'
#' @rdname sfn_delete_state_machine_alias
sfn_delete_state_machine_alias <- function(stateMachineAliasArn) {
  op <- new_operation(
    name = "DeleteStateMachineAlias",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$delete_state_machine_alias_input(stateMachineAliasArn = stateMachineAliasArn)
  output <- .sfn$delete_state_machine_alias_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$delete_state_machine_alias <- sfn_delete_state_machine_alias

#' Deletes a state machine version
#'
#' @description
#' Deletes a state machine [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html). After you delete a version, you can't call [`start_execution`][sfn_start_execution] using that version's ARN or use the version with a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_delete_state_machine_version/](https://www.paws-r-sdk.com/docs/sfn_delete_state_machine_version/) for full documentation.
#'
#' @param stateMachineVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine version to delete.
#'
#' @keywords internal
#'
#' @rdname sfn_delete_state_machine_version
sfn_delete_state_machine_version <- function(stateMachineVersionArn) {
  op <- new_operation(
    name = "DeleteStateMachineVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$delete_state_machine_version_input(stateMachineVersionArn = stateMachineVersionArn)
  output <- .sfn$delete_state_machine_version_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$delete_state_machine_version <- sfn_delete_state_machine_version

#' Describes an activity
#'
#' @description
#' Describes an activity.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_describe_activity/](https://www.paws-r-sdk.com/docs/sfn_describe_activity/) for full documentation.
#'
#' @param activityArn &#91;required&#93; The Amazon Resource Name (ARN) of the activity to describe.
#'
#' @keywords internal
#'
#' @rdname sfn_describe_activity
sfn_describe_activity <- function(activityArn) {
  op <- new_operation(
    name = "DescribeActivity",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$describe_activity_input(activityArn = activityArn)
  output <- .sfn$describe_activity_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$describe_activity <- sfn_describe_activity

#' Provides information about a state machine execution, such as the state
#' machine associated with the execution, the execution input and output,
#' and relevant execution metadata
#'
#' @description
#' Provides information about a state machine execution, such as the state machine associated with the execution, the execution input and output, and relevant execution metadata. If you've [redriven](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html) an execution, you can use this API action to return information about the redrives of that execution. In addition, you can use this API action to return the Map Run Amazon Resource Name (ARN) if the execution was dispatched by a Map Run.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_describe_execution/](https://www.paws-r-sdk.com/docs/sfn_describe_execution/) for full documentation.
#'
#' @param executionArn &#91;required&#93; The Amazon Resource Name (ARN) of the execution to describe.
#' @param includedData If your state machine definition is encrypted with a KMS key, callers
#' must have `kms:Decrypt` permission to decrypt the definition.
#' Alternatively, you can call DescribeStateMachine API with
#' `includedData = METADATA_ONLY` to get a successful response without the
#' encrypted definition.
#'
#' @keywords internal
#'
#' @rdname sfn_describe_execution
sfn_describe_execution <- function(executionArn, includedData = NULL) {
  op <- new_operation(
    name = "DescribeExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$describe_execution_input(executionArn = executionArn, includedData = includedData)
  output <- .sfn$describe_execution_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$describe_execution <- sfn_describe_execution

#' Provides information about a Map Run's configuration, progress, and
#' results
#'
#' @description
#' Provides information about a Map Run's configuration, progress, and results. If you've [redriven](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html) a Map Run, this API action also returns information about the redrives of that Map Run. For more information, see [Examining Map Run](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html) in the *Step Functions Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_describe_map_run/](https://www.paws-r-sdk.com/docs/sfn_describe_map_run/) for full documentation.
#'
#' @param mapRunArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies a Map Run.
#'
#' @keywords internal
#'
#' @rdname sfn_describe_map_run
sfn_describe_map_run <- function(mapRunArn) {
  op <- new_operation(
    name = "DescribeMapRun",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$describe_map_run_input(mapRunArn = mapRunArn)
  output <- .sfn$describe_map_run_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$describe_map_run <- sfn_describe_map_run

#' Provides information about a state machine's definition, its IAM role
#' Amazon Resource Name (ARN), and configuration
#'
#' @description
#' Provides information about a state machine's definition, its IAM role Amazon Resource Name (ARN), and configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_describe_state_machine/](https://www.paws-r-sdk.com/docs/sfn_describe_state_machine/) for full documentation.
#'
#' @param stateMachineArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine for which you want
#' the information.
#' 
#' If you specify a state machine version ARN, this API returns details
#' about that version. The version ARN is a combination of state machine
#' ARN and the version number separated by a colon (:). For example,
#' `stateMachineARN:1`.
#' @param includedData If your state machine definition is encrypted with a KMS key, callers
#' must have `kms:Decrypt` permission to decrypt the definition.
#' Alternatively, you can call the API with `includedData = METADATA_ONLY`
#' to get a successful response without the encrypted definition.
#' 
#' When calling a labelled ARN for an encrypted state machine, the
#' `includedData = METADATA_ONLY` parameter will not apply because Step
#' Functions needs to decrypt the entire state machine definition to get
#' the Distributed Map state’s definition. In this case, the API caller
#' needs to have `kms:Decrypt` permission.
#'
#' @keywords internal
#'
#' @rdname sfn_describe_state_machine
sfn_describe_state_machine <- function(stateMachineArn, includedData = NULL) {
  op <- new_operation(
    name = "DescribeStateMachine",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$describe_state_machine_input(stateMachineArn = stateMachineArn, includedData = includedData)
  output <- .sfn$describe_state_machine_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$describe_state_machine <- sfn_describe_state_machine

#' Returns details about a state machine alias
#'
#' @description
#' Returns details about a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_describe_state_machine_alias/](https://www.paws-r-sdk.com/docs/sfn_describe_state_machine_alias/) for full documentation.
#'
#' @param stateMachineAliasArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine alias.
#'
#' @keywords internal
#'
#' @rdname sfn_describe_state_machine_alias
sfn_describe_state_machine_alias <- function(stateMachineAliasArn) {
  op <- new_operation(
    name = "DescribeStateMachineAlias",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$describe_state_machine_alias_input(stateMachineAliasArn = stateMachineAliasArn)
  output <- .sfn$describe_state_machine_alias_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$describe_state_machine_alias <- sfn_describe_state_machine_alias

#' Provides information about a state machine's definition, its execution
#' role ARN, and configuration
#'
#' @description
#' Provides information about a state machine's definition, its execution role ARN, and configuration. If a Map Run dispatched the execution, this action returns the Map Run Amazon Resource Name (ARN) in the response. The state machine returned is the state machine associated with the Map Run.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_describe_state_machine_for_execution/](https://www.paws-r-sdk.com/docs/sfn_describe_state_machine_for_execution/) for full documentation.
#'
#' @param executionArn &#91;required&#93; The Amazon Resource Name (ARN) of the execution you want state machine
#' information for.
#' @param includedData If your state machine definition is encrypted with a KMS key, callers
#' must have `kms:Decrypt` permission to decrypt the definition.
#' Alternatively, you can call the API with `includedData = METADATA_ONLY`
#' to get a successful response without the encrypted definition.
#'
#' @keywords internal
#'
#' @rdname sfn_describe_state_machine_for_execution
sfn_describe_state_machine_for_execution <- function(executionArn, includedData = NULL) {
  op <- new_operation(
    name = "DescribeStateMachineForExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$describe_state_machine_for_execution_input(executionArn = executionArn, includedData = includedData)
  output <- .sfn$describe_state_machine_for_execution_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$describe_state_machine_for_execution <- sfn_describe_state_machine_for_execution

#' Used by workers to retrieve a task (with the specified activity ARN)
#' which has been scheduled for execution by a running state machine
#'
#' @description
#' Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a `taskToken` with a null string.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_get_activity_task/](https://www.paws-r-sdk.com/docs/sfn_get_activity_task/) for full documentation.
#'
#' @param activityArn &#91;required&#93; The Amazon Resource Name (ARN) of the activity to retrieve tasks from
#' (assigned when you create the task using
#' [`create_activity`][sfn_create_activity].)
#' @param workerName You can provide an arbitrary name in order to identify the worker that
#' the task is assigned to. This name is used when it is logged in the
#' execution history.
#'
#' @keywords internal
#'
#' @rdname sfn_get_activity_task
sfn_get_activity_task <- function(activityArn, workerName = NULL) {
  op <- new_operation(
    name = "GetActivityTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$get_activity_task_input(activityArn = activityArn, workerName = workerName)
  output <- .sfn$get_activity_task_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$get_activity_task <- sfn_get_activity_task

#' Returns the history of the specified execution as a list of events
#'
#' @description
#' Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the `timeStamp` of the events. Use the `reverseOrder` parameter to get the latest events first.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_get_execution_history/](https://www.paws-r-sdk.com/docs/sfn_get_execution_history/) for full documentation.
#'
#' @param executionArn &#91;required&#93; The Amazon Resource Name (ARN) of the execution.
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results. The default is 100 and
#' the maximum allowed page size is 1000. A value of 0 uses the default.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#' @param reverseOrder Lists events in descending order of their `timeStamp`.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken*
#' error.
#' @param includeExecutionData You can select whether execution data (input or output of a history
#' event) is returned. The default is `true`.
#'
#' @keywords internal
#'
#' @rdname sfn_get_execution_history
sfn_get_execution_history <- function(executionArn, maxResults = NULL, reverseOrder = NULL, nextToken = NULL, includeExecutionData = NULL) {
  op <- new_operation(
    name = "GetExecutionHistory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "events")
  )
  input <- .sfn$get_execution_history_input(executionArn = executionArn, maxResults = maxResults, reverseOrder = reverseOrder, nextToken = nextToken, includeExecutionData = includeExecutionData)
  output <- .sfn$get_execution_history_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$get_execution_history <- sfn_get_execution_history

#' Lists the existing activities
#'
#' @description
#' Lists the existing activities.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_list_activities/](https://www.paws-r-sdk.com/docs/sfn_list_activities/) for full documentation.
#'
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results. The default is 100 and
#' the maximum allowed page size is 1000. A value of 0 uses the default.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken*
#' error.
#'
#' @keywords internal
#'
#' @rdname sfn_list_activities
sfn_list_activities <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListActivities",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "activities")
  )
  input <- .sfn$list_activities_input(maxResults = maxResults, nextToken = nextToken)
  output <- .sfn$list_activities_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$list_activities <- sfn_list_activities

#' Lists all executions of a state machine or a Map Run
#'
#' @description
#' Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN. Using this API action, you can also list all [redriven](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html) executions.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_list_executions/](https://www.paws-r-sdk.com/docs/sfn_list_executions/) for full documentation.
#'
#' @param stateMachineArn The Amazon Resource Name (ARN) of the state machine whose executions is
#' listed.
#' 
#' You can specify either a `mapRunArn` or a `stateMachineArn`, but not
#' both.
#' 
#' You can also return a list of executions associated with a specific
#' [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html)
#' or
#' [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html),
#' by specifying an alias ARN or a version ARN in the `stateMachineArn`
#' parameter.
#' @param statusFilter If specified, only list the executions whose current execution status
#' matches the given filter.
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results. The default is 100 and
#' the maximum allowed page size is 1000. A value of 0 uses the default.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken*
#' error.
#' @param mapRunArn The Amazon Resource Name (ARN) of the Map Run that started the child
#' workflow executions. If the `mapRunArn` field is specified, a list of
#' all of the child workflow executions started by a Map Run is returned.
#' For more information, see [Examining Map
#' Run](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html)
#' in the *Step Functions Developer Guide*.
#' 
#' You can specify either a `mapRunArn` or a `stateMachineArn`, but not
#' both.
#' @param redriveFilter Sets a filter to list executions based on whether or not they have been
#' redriven.
#' 
#' For a Distributed Map, `redriveFilter` sets a filter to list child
#' workflow executions based on whether or not they have been redriven.
#' 
#' If you do not provide a `redriveFilter`, Step Functions returns a list
#' of both redriven and non-redriven executions.
#' 
#' If you provide a state machine ARN in `redriveFilter`, the API returns a
#' validation exception.
#'
#' @keywords internal
#'
#' @rdname sfn_list_executions
sfn_list_executions <- function(stateMachineArn = NULL, statusFilter = NULL, maxResults = NULL, nextToken = NULL, mapRunArn = NULL, redriveFilter = NULL) {
  op <- new_operation(
    name = "ListExecutions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "executions")
  )
  input <- .sfn$list_executions_input(stateMachineArn = stateMachineArn, statusFilter = statusFilter, maxResults = maxResults, nextToken = nextToken, mapRunArn = mapRunArn, redriveFilter = redriveFilter)
  output <- .sfn$list_executions_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$list_executions <- sfn_list_executions

#' Lists all Map Runs that were started by a given state machine execution
#'
#' @description
#' Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run ARNs, and then call [`describe_map_run`][sfn_describe_map_run] to obtain more information, if needed.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_list_map_runs/](https://www.paws-r-sdk.com/docs/sfn_list_map_runs/) for full documentation.
#'
#' @param executionArn &#91;required&#93; The Amazon Resource Name (ARN) of the execution for which the Map Runs
#' must be listed.
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results. The default is 100 and
#' the maximum allowed page size is 1000. A value of 0 uses the default.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken*
#' error.
#'
#' @keywords internal
#'
#' @rdname sfn_list_map_runs
sfn_list_map_runs <- function(executionArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListMapRuns",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "mapRuns")
  )
  input <- .sfn$list_map_runs_input(executionArn = executionArn, maxResults = maxResults, nextToken = nextToken)
  output <- .sfn$list_map_runs_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$list_map_runs <- sfn_list_map_runs

#' Lists aliases for a specified state machine ARN
#'
#' @description
#' Lists [aliases](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) for a specified state machine ARN. Results are sorted by time, with the most recently created aliases listed first.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_list_state_machine_aliases/](https://www.paws-r-sdk.com/docs/sfn_list_state_machine_aliases/) for full documentation.
#'
#' @param stateMachineArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine for which you want
#' to list aliases.
#' 
#' If you specify a state machine version ARN, this API returns a list of
#' aliases for that version.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken*
#' error.
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results. The default is 100 and
#' the maximum allowed page size is 1000. A value of 0 uses the default.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#'
#' @keywords internal
#'
#' @rdname sfn_list_state_machine_aliases
sfn_list_state_machine_aliases <- function(stateMachineArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListStateMachineAliases",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$list_state_machine_aliases_input(stateMachineArn = stateMachineArn, nextToken = nextToken, maxResults = maxResults)
  output <- .sfn$list_state_machine_aliases_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$list_state_machine_aliases <- sfn_list_state_machine_aliases

#' Lists versions for the specified state machine Amazon Resource Name
#' (ARN)
#'
#' @description
#' Lists [versions](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) for the specified state machine Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_list_state_machine_versions/](https://www.paws-r-sdk.com/docs/sfn_list_state_machine_versions/) for full documentation.
#'
#' @param stateMachineArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken*
#' error.
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results. The default is 100 and
#' the maximum allowed page size is 1000. A value of 0 uses the default.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#'
#' @keywords internal
#'
#' @rdname sfn_list_state_machine_versions
sfn_list_state_machine_versions <- function(stateMachineArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListStateMachineVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$list_state_machine_versions_input(stateMachineArn = stateMachineArn, nextToken = nextToken, maxResults = maxResults)
  output <- .sfn$list_state_machine_versions_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$list_state_machine_versions <- sfn_list_state_machine_versions

#' Lists the existing state machines
#'
#' @description
#' Lists the existing state machines.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_list_state_machines/](https://www.paws-r-sdk.com/docs/sfn_list_state_machines/) for full documentation.
#'
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results. The default is 100 and
#' the maximum allowed page size is 1000. A value of 0 uses the default.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken*
#' error.
#'
#' @keywords internal
#'
#' @rdname sfn_list_state_machines
sfn_list_state_machines <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListStateMachines",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "stateMachines")
  )
  input <- .sfn$list_state_machines_input(maxResults = maxResults, nextToken = nextToken)
  output <- .sfn$list_state_machines_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$list_state_machines <- sfn_list_state_machines

#' List tags for a given resource
#'
#' @description
#' List tags for a given resource.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/sfn_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the Step Functions state machine or
#' activity.
#'
#' @keywords internal
#'
#' @rdname sfn_list_tags_for_resource
sfn_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .sfn$list_tags_for_resource_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$list_tags_for_resource <- sfn_list_tags_for_resource

#' Creates a version from the current revision of a state machine
#'
#' @description
#' Creates a [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) from the current revision of a state machine. Use versions to create immutable snapshots of your state machine. You can start executions from versions either directly or with an alias. To create an alias, use [`create_state_machine_alias`][sfn_create_state_machine_alias].
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_publish_state_machine_version/](https://www.paws-r-sdk.com/docs/sfn_publish_state_machine_version/) for full documentation.
#'
#' @param stateMachineArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine.
#' @param revisionId Only publish the state machine version if the current state machine's
#' revision ID matches the specified ID.
#' 
#' Use this option to avoid publishing a version if the state machine
#' changed since you last updated it. If the specified revision ID doesn't
#' match the state machine's current revision ID, the API returns
#' `ConflictException`.
#' 
#' To specify an initial revision ID for a state machine with no revision
#' ID assigned, specify the string `INITIAL` for the `revisionId`
#' parameter. For example, you can specify a `revisionID` of `INITIAL` when
#' you create a state machine using the
#' [`create_state_machine`][sfn_create_state_machine] API action.
#' @param description An optional description of the state machine version.
#'
#' @keywords internal
#'
#' @rdname sfn_publish_state_machine_version
sfn_publish_state_machine_version <- function(stateMachineArn, revisionId = NULL, description = NULL) {
  op <- new_operation(
    name = "PublishStateMachineVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$publish_state_machine_version_input(stateMachineArn = stateMachineArn, revisionId = revisionId, description = description)
  output <- .sfn$publish_state_machine_version_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$publish_state_machine_version <- sfn_publish_state_machine_version

#' Restarts unsuccessful executions of Standard workflows that didn't
#' complete successfully in the last 14 days
#'
#' @description
#' Restarts unsuccessful executions of Standard workflows that didn't complete successfully in the last 14 days. These include failed, aborted, or timed out executions. When you [redrive](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html) an execution, it continues the failed execution from the unsuccessful step and uses the same input. Step Functions preserves the results and execution history of the successful steps, and doesn't rerun these steps when you redrive an execution. Redriven executions use the same state machine definition and execution ARN as the original execution attempt.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_redrive_execution/](https://www.paws-r-sdk.com/docs/sfn_redrive_execution/) for full documentation.
#'
#' @param executionArn &#91;required&#93; The Amazon Resource Name (ARN) of the execution to be redriven.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the
#' Amazon Web Services SDK automatically generates a client token and uses
#' it for the request to ensure idempotency. The API will return idempotent
#' responses for the last 10 client tokens used to successfully redrive the
#' execution. These client tokens are valid for up to 15 minutes after they
#' are first used.
#'
#' @keywords internal
#'
#' @rdname sfn_redrive_execution
sfn_redrive_execution <- function(executionArn, clientToken = NULL) {
  op <- new_operation(
    name = "RedriveExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$redrive_execution_input(executionArn = executionArn, clientToken = clientToken)
  output <- .sfn$redrive_execution_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$redrive_execution <- sfn_redrive_execution

#' Used by activity workers, Task states using the callback pattern, and
#' optionally Task states using the job run pattern to report that the task
#' identified by the taskToken failed
#'
#' @description
#' Used by activity workers, Task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern, and optionally Task states using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) pattern to report that the task identified by the `taskToken` failed.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_send_task_failure/](https://www.paws-r-sdk.com/docs/sfn_send_task_failure/) for full documentation.
#'
#' @param taskToken &#91;required&#93; The token that represents this task. Task tokens are generated by Step
#' Functions when tasks are assigned to a worker, or in the [context
#' object](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html)
#' when a workflow enters a task state. See
#' GetActivityTaskOutput$taskToken.
#' @param error The error code of the failure.
#' @param cause A more detailed explanation of the cause of the failure.
#'
#' @keywords internal
#'
#' @rdname sfn_send_task_failure
sfn_send_task_failure <- function(taskToken, error = NULL, cause = NULL) {
  op <- new_operation(
    name = "SendTaskFailure",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$send_task_failure_input(taskToken = taskToken, error = error, cause = cause)
  output <- .sfn$send_task_failure_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$send_task_failure <- sfn_send_task_failure

#' Used by activity workers and Task states using the callback pattern, and
#' optionally Task states using the job run pattern to report to Step
#' Functions that the task represented by the specified taskToken is still
#' making progress
#'
#' @description
#' Used by activity workers and Task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern, and optionally Task states using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) pattern to report to Step Functions that the task represented by the specified `taskToken` is still making progress. This action resets the `Heartbeat` clock. The `Heartbeat` threshold is specified in the state machine's Amazon States Language definition (`HeartbeatSeconds`). This action does not in itself create an event in the execution history. However, if the task times out, the execution history contains an `ActivityTimedOut` entry for activities, or a `TaskTimedOut` entry for tasks using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) or [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_send_task_heartbeat/](https://www.paws-r-sdk.com/docs/sfn_send_task_heartbeat/) for full documentation.
#'
#' @param taskToken &#91;required&#93; The token that represents this task. Task tokens are generated by Step
#' Functions when tasks are assigned to a worker, or in the [context
#' object](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html)
#' when a workflow enters a task state. See
#' GetActivityTaskOutput$taskToken.
#'
#' @keywords internal
#'
#' @rdname sfn_send_task_heartbeat
sfn_send_task_heartbeat <- function(taskToken) {
  op <- new_operation(
    name = "SendTaskHeartbeat",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$send_task_heartbeat_input(taskToken = taskToken)
  output <- .sfn$send_task_heartbeat_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$send_task_heartbeat <- sfn_send_task_heartbeat

#' Used by activity workers, Task states using the callback pattern, and
#' optionally Task states using the job run pattern to report that the task
#' identified by the taskToken completed successfully
#'
#' @description
#' Used by activity workers, Task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern, and optionally Task states using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) pattern to report that the task identified by the `taskToken` completed successfully.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_send_task_success/](https://www.paws-r-sdk.com/docs/sfn_send_task_success/) for full documentation.
#'
#' @param taskToken &#91;required&#93; The token that represents this task. Task tokens are generated by Step
#' Functions when tasks are assigned to a worker, or in the [context
#' object](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html)
#' when a workflow enters a task state. See
#' GetActivityTaskOutput$taskToken.
#' @param output &#91;required&#93; The JSON output of the task. Length constraints apply to the payload
#' size, and are expressed as bytes in UTF-8 encoding.
#'
#' @keywords internal
#'
#' @rdname sfn_send_task_success
sfn_send_task_success <- function(taskToken, output) {
  op <- new_operation(
    name = "SendTaskSuccess",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$send_task_success_input(taskToken = taskToken, output = output)
  output <- .sfn$send_task_success_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$send_task_success <- sfn_send_task_success

#' Starts a state machine execution
#'
#' @description
#' Starts a state machine execution.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_start_execution/](https://www.paws-r-sdk.com/docs/sfn_start_execution/) for full documentation.
#'
#' @param stateMachineArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine to execute.
#' 
#' The `stateMachineArn` parameter accepts one of the following inputs:
#' 
#' -   **An unqualified state machine ARN** – Refers to a state machine ARN
#'     that isn't qualified with a version or alias ARN. The following is
#'     an example of an unqualified state machine ARN.
#' 
#'     `arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>`
#' 
#'     Step Functions doesn't associate state machine executions that you
#'     start with an unqualified ARN with a version. This is true even if
#'     that version uses the same revision that the execution used.
#' 
#' -   **A state machine version ARN** – Refers to a version ARN, which is
#'     a combination of state machine ARN and the version number separated
#'     by a colon (:). The following is an example of the ARN for version
#'     10.
#' 
#'     `arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>:10`
#' 
#'     Step Functions doesn't associate executions that you start with a
#'     version ARN with any aliases that point to that version.
#' 
#' -   **A state machine alias ARN** – Refers to an alias ARN, which is a
#'     combination of state machine ARN and the alias name separated by a
#'     colon (:). The following is an example of the ARN for an alias named
#'     `PROD`.
#' 
#'     `arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine:PROD>`
#' 
#'     Step Functions associates executions that you start with an alias
#'     ARN with that alias and the state machine version used for that
#'     execution.
#' @param name Optional name of the execution. This name must be unique for your Amazon
#' Web Services account, Region, and state machine for 90 days. For more
#' information, see [Limits Related to State Machine
#' Executions](https://docs.aws.amazon.com/step-functions/latest/dg/service-quotas.html#service-limits-state-machine-executions)
#' in the *Step Functions Developer Guide*.
#' 
#' If you don't provide a name for the execution, Step Functions
#' automatically generates a universally unique identifier (UUID) as the
#' execution name.
#' 
#' A name must *not* contain:
#' 
#' -   white space
#' 
#' -   brackets `< > { } [ ]`
#' 
#' -   wildcard characters `? *`
#' 
#' -   special characters `` \" # % \ ^ | ~ \` $ & , ; : / ``
#' 
#' -   control characters (`U+0000-001F`, `U+007F-009F`)
#' 
#' To enable logging with CloudWatch Logs, the name should only contain
#' 0-9, A-Z, a-z, - and _.
#' @param input The string that contains the JSON input data for the execution, for
#' example:
#' 
#' `"input": "{\"first_name\" : \"test\"}"`
#' 
#' If you don't include any JSON input data, you still must include the two
#' braces, for example: `"input": "{}"`
#' 
#' Length constraints apply to the payload size, and are expressed as bytes
#' in UTF-8 encoding.
#' @param traceHeader Passes the X-Ray trace header. The trace header can also be passed in
#' the request payload.
#'
#' @keywords internal
#'
#' @rdname sfn_start_execution
sfn_start_execution <- function(stateMachineArn, name = NULL, input = NULL, traceHeader = NULL) {
  op <- new_operation(
    name = "StartExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$start_execution_input(stateMachineArn = stateMachineArn, name = name, input = input, traceHeader = traceHeader)
  output <- .sfn$start_execution_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$start_execution <- sfn_start_execution

#' Starts a Synchronous Express state machine execution
#'
#' @description
#' Starts a Synchronous Express state machine execution. [`start_sync_execution`][sfn_start_sync_execution] is not available for `STANDARD` workflows.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_start_sync_execution/](https://www.paws-r-sdk.com/docs/sfn_start_sync_execution/) for full documentation.
#'
#' @param stateMachineArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine to execute.
#' @param name The name of the execution.
#' @param input The string that contains the JSON input data for the execution, for
#' example:
#' 
#' `"input": "{\"first_name\" : \"test\"}"`
#' 
#' If you don't include any JSON input data, you still must include the two
#' braces, for example: `"input": "{}"`
#' 
#' Length constraints apply to the payload size, and are expressed as bytes
#' in UTF-8 encoding.
#' @param traceHeader Passes the X-Ray trace header. The trace header can also be passed in
#' the request payload.
#' @param includedData If your state machine definition is encrypted with a KMS key, callers
#' must have `kms:Decrypt` permission to decrypt the definition.
#' Alternatively, you can call the API with `includedData = METADATA_ONLY`
#' to get a successful response without the encrypted definition.
#'
#' @keywords internal
#'
#' @rdname sfn_start_sync_execution
sfn_start_sync_execution <- function(stateMachineArn, name = NULL, input = NULL, traceHeader = NULL, includedData = NULL) {
  op <- new_operation(
    name = "StartSyncExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "sync-",
    paginator = list()
  )
  input <- .sfn$start_sync_execution_input(stateMachineArn = stateMachineArn, name = name, input = input, traceHeader = traceHeader, includedData = includedData)
  output <- .sfn$start_sync_execution_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$start_sync_execution <- sfn_start_sync_execution

#' Stops an execution
#'
#' @description
#' Stops an execution.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_stop_execution/](https://www.paws-r-sdk.com/docs/sfn_stop_execution/) for full documentation.
#'
#' @param executionArn &#91;required&#93; The Amazon Resource Name (ARN) of the execution to stop.
#' @param error The error code of the failure.
#' @param cause A more detailed explanation of the cause of the failure.
#'
#' @keywords internal
#'
#' @rdname sfn_stop_execution
sfn_stop_execution <- function(executionArn, error = NULL, cause = NULL) {
  op <- new_operation(
    name = "StopExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$stop_execution_input(executionArn = executionArn, error = error, cause = cause)
  output <- .sfn$stop_execution_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$stop_execution <- sfn_stop_execution

#' Add a tag to a Step Functions resource
#'
#' @description
#' Add a tag to a Step Functions resource.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_tag_resource/](https://www.paws-r-sdk.com/docs/sfn_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the Step Functions state machine or
#' activity.
#' @param tags &#91;required&#93; The list of tags to add to a resource.
#' 
#' Tags may only contain Unicode letters, digits, white space, or these
#' symbols: `_ . : / = + - @@`.
#'
#' @keywords internal
#'
#' @rdname sfn_tag_resource
sfn_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .sfn$tag_resource_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$tag_resource <- sfn_tag_resource

#' Accepts the definition of a single state and executes it
#'
#' @description
#' Accepts the definition of a single state and executes it. You can test a state without creating a state machine or updating an existing state machine. Using this API, you can test the following:
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_test_state/](https://www.paws-r-sdk.com/docs/sfn_test_state/) for full documentation.
#'
#' @param definition &#91;required&#93; The [Amazon States
#' Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html)
#' (ASL) definition of the state.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the execution role with the required
#' IAM permissions for the state.
#' @param input A string that contains the JSON input data for the state.
#' @param inspectionLevel Determines the values to return when a state is tested. You can specify
#' one of the following types:
#' 
#' -   `INFO`: Shows the final state output. By default, Step Functions
#'     sets `inspectionLevel` to `INFO` if you don't specify a level.
#' 
#' -   `DEBUG`: Shows the final state output along with the input and
#'     output data processing result.
#' 
#' -   `TRACE`: Shows the HTTP request and response for an HTTP Task. This
#'     level also shows the final state output along with the input and
#'     output data processing result.
#' 
#' Each of these levels also provide information about the status of the
#' state execution and the next state to transition to.
#' @param revealSecrets Specifies whether or not to include secret information in the test
#' result. For HTTP Tasks, a secret includes the data that an EventBridge
#' connection adds to modify the HTTP request headers, query parameters,
#' and body. Step Functions doesn't omit any information included in the
#' state definition or the HTTP response.
#' 
#' If you set `revealSecrets` to `true`, you must make sure that the IAM
#' user that calls the [`test_state`][sfn_test_state] API has permission
#' for the `states:RevealSecrets` action. For an example of IAM policy that
#' sets the `states:RevealSecrets` permission, see [IAM permissions to test
#' a
#' state](https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions).
#' Without this permission, Step Functions throws an access denied error.
#' 
#' By default, `revealSecrets` is set to `false`.
#'
#' @keywords internal
#'
#' @rdname sfn_test_state
sfn_test_state <- function(definition, roleArn, input = NULL, inspectionLevel = NULL, revealSecrets = NULL) {
  op <- new_operation(
    name = "TestState",
    http_method = "POST",
    http_path = "/",
    host_prefix = "sync-",
    paginator = list()
  )
  input <- .sfn$test_state_input(definition = definition, roleArn = roleArn, input = input, inspectionLevel = inspectionLevel, revealSecrets = revealSecrets)
  output <- .sfn$test_state_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$test_state <- sfn_test_state

#' Remove a tag from a Step Functions resource
#'
#' @description
#' Remove a tag from a Step Functions resource
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_untag_resource/](https://www.paws-r-sdk.com/docs/sfn_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the Step Functions state machine or
#' activity.
#' @param tagKeys &#91;required&#93; The list of tags to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname sfn_untag_resource
sfn_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .sfn$untag_resource_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$untag_resource <- sfn_untag_resource

#' Updates an in-progress Map Run's configuration to include changes to the
#' settings that control maximum concurrency and Map Run failure
#'
#' @description
#' Updates an in-progress Map Run's configuration to include changes to the settings that control maximum concurrency and Map Run failure.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_update_map_run/](https://www.paws-r-sdk.com/docs/sfn_update_map_run/) for full documentation.
#'
#' @param mapRunArn &#91;required&#93; The Amazon Resource Name (ARN) of a Map Run.
#' @param maxConcurrency The maximum number of child workflow executions that can be specified to
#' run in parallel for the Map Run at the same time.
#' @param toleratedFailurePercentage The maximum percentage of failed items before the Map Run fails.
#' @param toleratedFailureCount The maximum number of failed items before the Map Run fails.
#'
#' @keywords internal
#'
#' @rdname sfn_update_map_run
sfn_update_map_run <- function(mapRunArn, maxConcurrency = NULL, toleratedFailurePercentage = NULL, toleratedFailureCount = NULL) {
  op <- new_operation(
    name = "UpdateMapRun",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$update_map_run_input(mapRunArn = mapRunArn, maxConcurrency = maxConcurrency, toleratedFailurePercentage = toleratedFailurePercentage, toleratedFailureCount = toleratedFailureCount)
  output <- .sfn$update_map_run_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$update_map_run <- sfn_update_map_run

#' Updates an existing state machine by modifying its definition, roleArn,
#' loggingConfiguration, or EncryptionConfiguration
#'
#' @description
#' Updates an existing state machine by modifying its `definition`, `roleArn`, `loggingConfiguration`, or `EncryptionConfiguration`. Running executions will continue to use the previous `definition` and `roleArn`. You must include at least one of `definition` or `roleArn` or you will receive a `MissingRequiredParameter` error.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_update_state_machine/](https://www.paws-r-sdk.com/docs/sfn_update_state_machine/) for full documentation.
#'
#' @param stateMachineArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine.
#' @param definition The Amazon States Language definition of the state machine. See [Amazon
#' States
#' Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
#' @param roleArn The Amazon Resource Name (ARN) of the IAM role of the state machine.
#' @param loggingConfiguration Use the `LoggingConfiguration` data type to set CloudWatch Logs options.
#' @param tracingConfiguration Selects whether X-Ray tracing is enabled.
#' @param publish Specifies whether the state machine version is published. The default is
#' `false`. To publish a version after updating the state machine, set
#' `publish` to `true`.
#' @param versionDescription An optional description of the state machine version to publish.
#' 
#' You can only specify the `versionDescription` parameter if you've set
#' `publish` to `true`.
#' @param encryptionConfiguration Settings to configure server-side encryption.
#'
#' @keywords internal
#'
#' @rdname sfn_update_state_machine
sfn_update_state_machine <- function(stateMachineArn, definition = NULL, roleArn = NULL, loggingConfiguration = NULL, tracingConfiguration = NULL, publish = NULL, versionDescription = NULL, encryptionConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateStateMachine",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$update_state_machine_input(stateMachineArn = stateMachineArn, definition = definition, roleArn = roleArn, loggingConfiguration = loggingConfiguration, tracingConfiguration = tracingConfiguration, publish = publish, versionDescription = versionDescription, encryptionConfiguration = encryptionConfiguration)
  output <- .sfn$update_state_machine_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$update_state_machine <- sfn_update_state_machine

#' Updates the configuration of an existing state machine alias by
#' modifying its description or routingConfiguration
#'
#' @description
#' Updates the configuration of an existing state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) by modifying its `description` or `routingConfiguration`.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_update_state_machine_alias/](https://www.paws-r-sdk.com/docs/sfn_update_state_machine_alias/) for full documentation.
#'
#' @param stateMachineAliasArn &#91;required&#93; The Amazon Resource Name (ARN) of the state machine alias.
#' @param description A description of the state machine alias.
#' @param routingConfiguration The routing configuration of the state machine alias.
#' 
#' An array of `RoutingConfig` objects that specifies up to two state
#' machine versions that the alias starts executions for.
#'
#' @keywords internal
#'
#' @rdname sfn_update_state_machine_alias
sfn_update_state_machine_alias <- function(stateMachineAliasArn, description = NULL, routingConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateStateMachineAlias",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$update_state_machine_alias_input(stateMachineAliasArn = stateMachineAliasArn, description = description, routingConfiguration = routingConfiguration)
  output <- .sfn$update_state_machine_alias_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$update_state_machine_alias <- sfn_update_state_machine_alias

#' Validates the syntax of a state machine definition
#'
#' @description
#' Validates the syntax of a state machine definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sfn_validate_state_machine_definition/](https://www.paws-r-sdk.com/docs/sfn_validate_state_machine_definition/) for full documentation.
#'
#' @param definition &#91;required&#93; The Amazon States Language definition of the state machine. For more
#' information, see [Amazon States
#' Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html)
#' (ASL).
#' @param type The target type of state machine for this definition. The default is
#' `STANDARD`.
#' @param severity Minimum level of diagnostics to return. `ERROR` returns only `ERROR`
#' diagnostics, whereas `WARNING` returns both `WARNING` and `ERROR`
#' diagnostics. The default is `ERROR`.
#' @param maxResults The maximum number of diagnostics that are returned per call. The
#' default and maximum value is 100. Setting the value to 0 will also use
#' the default of 100.
#' 
#' If the number of diagnostics returned in the response exceeds
#' `maxResults`, the value of the `truncated` field in the response will be
#' set to `true`.
#'
#' @keywords internal
#'
#' @rdname sfn_validate_state_machine_definition
sfn_validate_state_machine_definition <- function(definition, type = NULL, severity = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ValidateStateMachineDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sfn$validate_state_machine_definition_input(definition = definition, type = type, severity = severity, maxResults = maxResults)
  output <- .sfn$validate_state_machine_definition_output()
  config <- get_config()
  svc <- .sfn$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sfn$operations$validate_state_machine_definition <- sfn_validate_state_machine_definition
