% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpc_endpoint}
\alias{ec2_modify_vpc_endpoint}
\title{Modifies attributes of a specified VPC endpoint}
\usage{
ec2_modify_vpc_endpoint(DryRun, VpcEndpointId, ResetPolicy,
  PolicyDocument, AddRouteTableIds, RemoveRouteTableIds, AddSubnetIds,
  RemoveSubnetIds, AddSecurityGroupIds, RemoveSecurityGroupIds,
  PrivateDnsEnabled)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcEndpointId}{[required] The ID of the endpoint.}

\item{ResetPolicy}{(Gateway endpoint) Specify \code{true} to reset the policy document to the
default policy. The default policy allows full access to the service.}

\item{PolicyDocument}{A policy to attach to the endpoint that controls access to the service.
The policy must be in valid JSON format. If this parameter is not
specified, we attach a default policy that allows full access to the
service.}

\item{AddRouteTableIds}{(Gateway endpoint) One or more route tables IDs to associate with the
endpoint.}

\item{RemoveRouteTableIds}{(Gateway endpoint) One or more route table IDs to disassociate from the
endpoint.}

\item{AddSubnetIds}{(Interface endpoint) One or more subnet IDs in which to serve the
endpoint.}

\item{RemoveSubnetIds}{(Interface endpoint) One or more subnets IDs in which to remove the
endpoint.}

\item{AddSecurityGroupIds}{(Interface endpoint) One or more security group IDs to associate with
the network interface.}

\item{RemoveSecurityGroupIds}{(Interface endpoint) One or more security group IDs to disassociate from
the network interface.}

\item{PrivateDnsEnabled}{(Interface endpoint) Indicate whether a private hosted zone is
associated with the VPC.}
}
\description{
Modifies attributes of a specified VPC endpoint. The attributes that you
can modify depend on the type of VPC endpoint (interface or gateway).
For more information, see \href{https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-endpoints.html}{VPC Endpoints}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$modify_vpc_endpoint(
  DryRun = TRUE|FALSE,
  VpcEndpointId = "string",
  ResetPolicy = TRUE|FALSE,
  PolicyDocument = "string",
  AddRouteTableIds = list(
    "string"
  ),
  RemoveRouteTableIds = list(
    "string"
  ),
  AddSubnetIds = list(
    "string"
  ),
  RemoveSubnetIds = list(
    "string"
  ),
  AddSecurityGroupIds = list(
    "string"
  ),
  RemoveSecurityGroupIds = list(
    "string"
  ),
  PrivateDnsEnabled = TRUE|FALSE
)
}
}

\keyword{internal}
