% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_deregister_image}
\alias{ec2_deregister_image}
\title{Deregisters the specified AMI}
\usage{
ec2_deregister_image(ImageId, DryRun)
}
\arguments{
\item{ImageId}{[required] The ID of the AMI.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Deregisters the specified AMI. After you deregister an AMI, it can't be
used to launch new instances; however, it doesn't affect any instances
that you've already launched from the AMI. You'll continue to incur
usage costs for those instances until you terminate them.

When you deregister an Amazon EBS-backed AMI, it doesn't affect the
snapshot that was created for the root volume of the instance during the
AMI creation process. When you deregister an instance store-backed AMI,
it doesn't affect the files that you uploaded to Amazon S3 when you
created the AMI.
}
\section{Request syntax}{
\preformatted{svc$deregister_image(
  ImageId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
