% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_spot_fleet_requests}
\alias{ec2_describe_spot_fleet_requests}
\title{Describes your Spot Fleet requests}
\usage{
ec2_describe_spot_fleet_requests(DryRun, MaxResults, NextToken,
  SpotFleetRequestIds)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 1 and 1000. The default value is 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next set of results.}

\item{SpotFleetRequestIds}{The IDs of the Spot Fleet requests.}
}
\description{
Describes your Spot Fleet requests.

Spot Fleet requests are deleted 48 hours after they are canceled and
their instances are terminated.
}
\section{Request syntax}{
\preformatted{svc$describe_spot_fleet_requests(
  DryRun = TRUE|FALSE,
  MaxResults = 123,
  NextToken = "string",
  SpotFleetRequestIds = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example describes the specified Spot fleet request.
svc$describe_spot_fleet_requests(
  SpotFleetRequestIds = list(
    "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"
  )
)
}

}
\keyword{internal}
