% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_managed_prefix_list}
\alias{ec2_modify_managed_prefix_list}
\title{Modifies the specified managed prefix list}
\usage{
ec2_modify_managed_prefix_list(DryRun, PrefixListId, CurrentVersion,
  PrefixListName, AddEntries, RemoveEntries)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PrefixListId}{[required] The ID of the prefix list.}

\item{CurrentVersion}{The current version of the prefix list.}

\item{PrefixListName}{A name for the prefix list.}

\item{AddEntries}{One or more entries to add to the prefix list.}

\item{RemoveEntries}{One or more entries to remove from the prefix list.}
}
\description{
Modifies the specified managed prefix list.

Adding or removing entries in a prefix list creates a new version of the
prefix list. Changing the name of the prefix list does not affect the
version.

If you specify a current version number that does not match the true
current version number, the request fails.
}
\section{Request syntax}{
\preformatted{svc$modify_managed_prefix_list(
  DryRun = TRUE|FALSE,
  PrefixListId = "string",
  CurrentVersion = 123,
  PrefixListName = "string",
  AddEntries = list(
    list(
      Cidr = "string",
      Description = "string"
    )
  ),
  RemoveEntries = list(
    list(
      Cidr = "string"
    )
  )
)
}
}

\keyword{internal}
